/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.vikamine.kernel.util.Filter;

public class FilterUtils {
    public static <T> List<T> applyFilter(Filter<T> fil, Collection<T> source) {
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : source) {
            if (!fil.applies(elem)) continue;
            result.add(elem);
        }
        return result;
    }

    public static <T> List<T> applyNegativeFilter(Filter<T> fil, Collection<T> source) {
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : source) {
            if (fil.applies(elem)) continue;
            result.add(elem);
        }
        return result;
    }

    public static <T> List<T> applyFilters(List<Filter<T>> filters, Collection<T> source) {
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : source) {
            boolean add = true;
            for (Filter<T> fil : filters) {
                if (fil.applies(elem)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(elem);
        }
        return result;
    }

    public static <T> List<T> applyNegativeFilters(List<Filter<T>> filters, Collection<T> source) {
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : source) {
            boolean add = true;
            for (Filter<T> fil : filters) {
                if (!fil.applies(elem)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(elem);
        }
        return result;
    }
}

