/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.quality.functions.AddedValueQF;
import org.vikamine.kernel.subgroup.quality.functions.AdjustedResidualQF;
import org.vikamine.kernel.subgroup.quality.functions.BinomialQF;
import org.vikamine.kernel.subgroup.quality.functions.ChiSquareQF;
import org.vikamine.kernel.subgroup.quality.functions.FMeasureQF;
import org.vikamine.kernel.subgroup.quality.functions.InformationGainQF;
import org.vikamine.kernel.subgroup.quality.functions.LiftQF;
import org.vikamine.kernel.subgroup.quality.functions.PiatetskyShapiroQF;
import org.vikamine.kernel.subgroup.quality.functions.PrecisionQF;
import org.vikamine.kernel.subgroup.quality.functions.RecallQF;
import org.vikamine.kernel.subgroup.quality.functions.SimpleBinomialQF;
import org.vikamine.kernel.subgroup.quality.functions.WRAccQF;

public class QualityFunctionRegistry {
    public static QualityFunctionRegistry instance = null;
    public static IQualityFunction[] BASE_FUNCTIONS = new IQualityFunction[]{new AddedValueQF(), new ChiSquareQF(), new LiftQF(), new PiatetskyShapiroQF(), new BinomialQF(), new SimpleBinomialQF(), new WRAccQF(), new InformationGainQF(), new FMeasureQF(), new PrecisionQF(), new RecallQF(), new AdjustedResidualQF()};
    private List<IQualityFunction> qualityFunctions = new ArrayList<IQualityFunction>();

    public static QualityFunctionRegistry getInstance() {
        if (instance == null) {
            instance = new QualityFunctionRegistry();
        }
        return instance;
    }

    public QualityFunctionRegistry() {
        this.qualityFunctions.addAll(Arrays.asList(BASE_FUNCTIONS));
    }

    public List<IQualityFunction> getQualityFunctions() {
        return this.qualityFunctions;
    }

    public void register(IQualityFunction qf) {
        this.qualityFunctions.add(qf);
    }

    public void register(int position, IQualityFunction qf) {
        this.qualityFunctions.add(position, qf);
    }
}

