% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ie_faca.R
\name{ie_faca}
\alias{ie_faca}
\title{Search for itemized Federal Advisory Committee memberships.}
\usage{
ie_faca(affiliation = NULL, agency_name = NULL, committee_name = NULL,
  member_name = NULL, year = NULL, page = NULL, per_page = NULL,
  as = "table", key = NULL, ...)
}
\arguments{
\item{affiliation}{(character) The name of the affiliated organization.}

\item{agency_name}{(character) The name of the agency associated with the committee.}

\item{committee_name}{(character) The name of the advisory committee.}

\item{member_name}{(character) Full-text search on the name of the affiliated organization.}

\item{year}{(integer) The YYYY-formatted year(s) the member sat on the committee.}

\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{as}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}
}
\value{
A data.frame, list, or httr response object
}
\description{
Search for itemized Federal Advisory Committee memberships.
}
\examples{
\dontrun{
ie_faca(member_name='Francis Collins', per_page=1)
ie_faca(agency_name='DOC', per_page=3)
ie_faca(affiliation='U.S. House of Representatives', per_page=3)
ie_faca(year=2011, per_page=1)
ie_faca(committee_name='2010 Census Advisory Committee', per_page=1)

# most parameters are vectorized, pass in more than one value
ie_faca(member_name = c('Francis Collins', 'Barbara Welty'))
ie_faca(agency_name = c('DOC', 'HHS'))
}
}

