% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_floor_updates.R
\name{cg_floor_updates}
\alias{cg_floor_updates}
\title{Search for data on upcoming bills.}
\usage{
cg_floor_updates(chamber = NULL, timestamp = NULL, congress = NULL,
  legislative_day = NULL, year = NULL, bill_ids = NULL, roll_ids = NULL,
  legislator_ids = NULL, query = NULL, fields = NULL, page = 1,
  per_page = 20, order = NULL, key = NULL, as = "table", ...)
}
\arguments{
\item{chamber}{The chamber this update took place in. 'house' or 'senate'.}

\item{timestamp}{The time this update took place. For Senate updates, this actually means the
time our system first observed the update, and is susceptible to error; the Senate does not
offer precise timestamps.}

\item{congress}{The number of the Congress this update took place during.}

\item{legislative_day}{The 'legislative day' this update took place in. The 'legislative day'
is a formal construct that is usually, but not always, the same as the calendar day. For
example, if a day's session of Congress runs past midnight, the legislative_day will often
stay the same as it was before midnight, until that session adjourns. On January 3rd, it is
possible that the same legislative_day could span two Congresses. (This occurred in 2013.)}

\item{year}{The 'legislative year' of the update. This is not quite the same as the calendar
year - the legislative year changes at noon EST on January 3rd. A vote taken on January 1, 2013
has a 'legislative year' of 2012.}

\item{bill_ids}{An array of IDs of bills that are referenced by or associated with this floor
update.}

\item{roll_ids}{An array of IDs of roll call votes that are referenced by or associated with
this floor update.}

\item{legislator_ids}{An array of bioguide IDs of legislators that are referenced by this floor
update.}

\item{query}{(character) Return results the API thinks best match your query. Queries are
interpreted as phrases.}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}

\item{key}{your SunlightLabs API key; loads from environment variable from .Renviron or
from an option from .Rprofile}

\item{as}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}
}
\description{
Search for data on upcoming bills.
}
\examples{
\dontrun{
cg_floor_updates()
cg_floor_updates(chamber='house', query='Agreed to by voice vote')

# most parameters are vectorized, pass in more than one value
cg_floor_updates(chamber = c("house", "senate"))
}
}

