% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/os_committees.R
\name{os_committees}
\alias{os_committees}
\title{Search OpenStates committees}
\usage{
os_committees(state = NULL, chamber = "upper", committee = NULL,
  subcommittee = NULL, as = "table", key = NULL, ...)
}
\arguments{
\item{state}{state two-letter abbreviation (character)}

\item{chamber}{one of 'upper' or 'lower' (character)}

\item{committee}{a committee name (character)}

\item{subcommittee}{a subcommittee name (character)}

\item{as}{(character) One of table (default), list, or response
(\code{crul} response object)}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
a data.frame of bills.
}
\description{
Search OpenStates committees
}
\details{
this route appears to not support pagination, sorting or
selecting fields
}
\examples{
\dontrun{
os_committees(state = 'tx')
os_committees(state = 'tx', chamber = 'upper')
os_committees(state = 'dc')
}
}
