% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_ticket_create.R
\name{rt_ticket_create}
\alias{rt_ticket_create}
\title{Create a ticket}
\usage{
rt_ticket_create(
  queue,
  requestor = NULL,
  subject = NULL,
  cc = NULL,
  admin_cc = NULL,
  owner = NULL,
  status = NULL,
  priority = NULL,
  initial_priority = NULL,
  final_priority = NULL,
  time_estimated = NULL,
  starts = NULL,
  due = NULL,
  text = NULL,
  custom_field = NULL,
  ...
)
}
\arguments{
\item{queue}{(character) The queue}

\item{requestor}{(character) Requestor email address}

\item{subject}{(character) Ticket subject}

\item{cc}{(character) Email address to cc}

\item{admin_cc}{(character) Admin email address to cc}

\item{owner}{(character) Owner username or email}

\item{status}{(character) Ticket status; typically "open", "new", "stalled",
or "resolved"}

\item{priority}{(numeric) Ticket priority}

\item{initial_priority}{(numeric) Ticket initial priority}

\item{final_priority}{(numeric) Ticket final priority}

\item{time_estimated}{(character) Time estimated}

\item{starts}{(character) Starts}

\item{due}{(character) Due date}

\item{text}{(character) Ticket content; if multi-line, prefix every line with
a blank}

\item{custom_field}{(vector) Takes a named vector of the custom field name
and custom field value}

\item{...}{Other arguments passed to \code{\link{rt_POST}}}
}
\value{
(numeric) The ID of the ticket
}
\description{
Create a ticket
}
\examples{
\dontrun{
# We can create an empty ticket
rt_ticket_create("General")

# Or we can provide some of the fields
rt_ticket_create("General",
                 requestor = "requestor@example.com",
                 subject = "An example ticket")
}
}
