% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/freqtable.R
\name{freqtable}
\alias{freqtable}
\title{FlexTable Percentage Table}
\usage{
freqtable(x, percent_digits = 1, label_na = "Missing",
  label_level = "Level", label_sum = "Sum", label_count = "#",
  label_percent = "\%", base100 = TRUE, percent = T, row_percent = T,
  col_percent = T, label_percent_col = "col \%",
  label_percent_row = "row \%")
}
\arguments{
\item{x}{a \code{table} object}

\item{percent_digits}{the desired number of digits after
the decimal point for percentages.}

\item{label_na}{label to use for \code{missing} level.}

\item{label_level}{label to use for level column (only for one way table).}

\item{label_sum}{label to use for margins.}

\item{label_count}{label to use for \code{frequencies}.}

\item{label_percent}{label to use for \code{percentages}.}

\item{base100}{wether to multiply percentages by 100.}

\item{percent}{whether to include cell percentages in the table.}

\item{row_percent}{whether to include cell percentages of
row frequencies in the table.}

\item{col_percent}{whether to include cell percentages of column
frequencies in the table.}

\item{label_percent_col}{label to use for \code{column frequencies}.}

\item{label_percent_row}{label to use for \code{row frequencies}.}
}
\value{
a \code{\link{FlexTable}} object
}
\description{
Get a \code{\link{FlexTable}} two-way frequency table.
Table contains cell frequencies, cell percentages of the total frequency,
cell percentages of row frequencies and cell percentages of column frequencies.
}
\examples{
#
am =  c( "automatic", "manual" )[mtcars$am+1]
carb = paste( mtcars$carb, "carburetor(s)")


my_freq_table = freqtable(table( am, carb ) )
print( my_freq_table )
if( interactive() ) readline("Hit <Return> to see next FlexTable:")


my_freq_table = freqtable(table( am, carb, useNA = "always") )
print( my_freq_table )
if( interactive() ) readline("Hit <Return> to see next FlexTable:")

}

