% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_toString.R
\name{propose_column_widths}
\alias{propose_column_widths}
\title{Propose Column Widths of an \code{rtable} object}
\usage{
propose_column_widths(x, mat_form = matrix_form(x, indent_rownames = TRUE))
}
\arguments{
\item{x}{\code{rtable} object}

\item{mat_form}{object as created with \code{matrix_form}}
}
\value{
a vector of column widths based on the content of \code{x} (or \code{mat_form} if explictly provided)
for use in printing and, in the future, in pagination.
}
\description{
The row names are also considered a column for the output
}
\examples{
library(dplyr)

iris2 <- iris \%>\%
  group_by(Species) \%>\%
  mutate(group = as.factor(rep_len(c("a", "b"), length.out = n()))) \%>\%
  ungroup()

l <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  split_cols_by("group") \%>\%
  analyze(c("Sepal.Length", "Petal.Width"), afun = list_wrap_x(summary) , format = "xx.xx")

tbl <- build_table(l, iris2)

propose_column_widths(tbl)
}
