% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\docType{class}
\name{ElementaryTable-class}
\alias{ElementaryTable-class}
\alias{ElementaryTable}
\alias{TableTree-class}
\alias{TableTree}
\title{TableTree classes}
\usage{
ElementaryTable(
  kids = list(),
  name = "",
  lev = 1L,
  label = "",
  labelrow = LabelRow(lev = lev, label = label, vis = !isTRUE(iscontent) &&
    !is.na(label) && nzchar(label)),
  rspans = data.frame(),
  cinfo = NULL,
  iscontent = NA,
  var = NA_character_,
  format = NULL,
  indent_mod = 0L,
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character()
)

TableTree(
  kids = list(),
  name = if (!is.na(var)) var else "",
  cont = EmptyElTable,
  lev = 1L,
  label = name,
  labelrow = LabelRow(lev = lev, label = label, vis = nrow(cont) == 0 && !is.na(label)
    && nzchar(label)),
  rspans = data.frame(),
  iscontent = NA,
  var = NA_character_,
  cinfo = NULL,
  format = NULL,
  indent_mod = 0L,
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character()
)
}
\arguments{
\item{kids}{list. List of direct children.}

\item{name}{character(1). Name of the split/table/row being creatted. Defaults to same as the corresponding llabel, but is not required to be.}

\item{lev}{integer. Nesting level (roughly, indentation level in practical terms).}

\item{label}{character(1). A label (not to be confused with the name) for the object/structure.}

\item{labelrow}{LabelRow. The LabelRow object to assign to this Table. Consructed from \code{label} by default if not specified.}

\item{rspans}{data.frame. Currently stored but otherwise ignored.}

\item{cinfo}{InstantiatedColumnInfo (or NULL). Column structure for the object being created.}

\item{iscontent}{logical. Is the TableTree/ElementaryTable being constructed the content table for another TableTree.}

\item{var}{string, variable name}

\item{format}{FormatSpec. Format associated with this split. Formats can be declared via strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can character vectors or lists of functions.}

\item{indent_mod}{numeric. Modifier for the default indent position for the structure created by this function(subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which corresponds to the unmodified default behavior.}

\item{title}{character(1). Main title. Ignored for subtables.}

\item{subtitles}{character. Subtitles. Ignored for subtables.}

\item{main_footer}{character. Main global (non-referential) footer materials.}

\item{prov_footer}{character. Provenance-related global footer materials. Generally should not be modified by hand.}

\item{cont}{ElementaryTable. Content table.}
}
\value{
A formal object representing a populated table.
}
\description{
TableTree classes

Table Constructors and Classes
}
\author{
Gabriel Becker

Gabriel Becker
}
