% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{rrowl}
\alias{rrowl}
\title{rrowl}
\usage{
rrowl(row.name, ..., format = NULL, indent = 0, inset = 0L)
}
\arguments{
\item{row.name}{if \code{NULL} then an empty string is used as
\code{row.name} of the \code{\link{rrow}}.}

\item{\dots}{values in vector/list form}

\item{format}{character(1) or function. The format label (string) or
formatter function to apply to the cell values passed via \code{...}. See
\code{\link[formatters]{list_valid_format_labels}} for currently supported
format labels.}

\item{indent}{deprecated.}

\item{inset}{integer(1). The table inset for the row or table being
constructed. See \code{\link[formatters]{table_inset}}.}
}
\value{
A row object of the context-appropriate type (label or data)
}
\description{
rrowl
}
\examples{
rrowl("a", c(1,2,3), format = "xx")
rrowl("a", c(1,2,3), c(4,5,6), format = "xx")


rrowl("N", table(iris$Species))
rrowl("N", table(iris$Species), format = "xx")

x <- tapply(iris$Sepal.Length, iris$Species, mean, simplify = FALSE)

rrow(row.name = "row 1", x)
rrow("ABC", 2, 3)

rrowl(row.name = "row 1", c(1, 2), c(3,4))
rrow(row.name = "row 2", c(1, 2), c(3,4))
}
\seealso{
Other compatibility: 
\code{\link{rheader}()},
\code{\link{rrow}()},
\code{\link{rtable}()}
}
\concept{compatibility}
