% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent.R
\name{indent}
\alias{indent}
\title{Change indentation of all \code{rrows} in an \code{rtable}}
\usage{
indent(x, by = 1)
}
\arguments{
\item{x}{\code{\link{rtable}} object}

\item{by}{integer to increase indentation of rows. Can be negative. If final indentation is smaller than 0 then the
indentation is set to 0.}
}
\value{
\code{x} with its indent modifier incremented by \code{by}.
}
\description{
Change indentation of all \code{rrows} in an \code{rtable}
}
\examples{
is_setosa <- iris$Species == "setosa"
m_tbl <- rtable(
  header = rheader(
    rrow(row.name = NULL, rcell("Sepal.Length", colspan = 2), rcell("Petal.Length", colspan=2)),
    rrow(NULL, "mean", "median", "mean", "median")
  ),
  rrow(
    row.name = "All Species",
    mean(iris$Sepal.Length), median(iris$Sepal.Length),
    mean(iris$Petal.Length), median(iris$Petal.Length),
    format = "xx.xx"
  ),
  rrow(
    row.name = "Setosa",
    mean(iris$Sepal.Length[is_setosa]), median(iris$Sepal.Length[is_setosa]),
    mean(iris$Petal.Length[is_setosa]), median(iris$Petal.Length[is_setosa]),
    format = "xx.xx"
  )
)
indent(m_tbl)
indent(m_tbl, 2)

}
