% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{analyze_colvars}
\alias{analyze_colvars}
\title{Generate rows analyzing different variables across columns}
\usage{
analyze_colvars(
  lyt,
  afun,
  format = NULL,
  na_str = NA_character_,
  nested = TRUE,
  extra_args = list(),
  indent_mod = 0L,
  inclNAs = FALSE
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{afun}{(\code{function} or \code{list})\cr function(s) to be used to calculate the values in each column. The list
will be repped out as needed and matched by position with the columns during tabulation. This functions
accepts the same parameters as \code{\link[=analyze]{analyze()}} like \code{afun} and \code{format}. For further information see
\link{additional_fun_params}.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr format associated with this split. Formats can be declared via
strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can be character vectors or lists of
functions. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for a list of all available format strings.}

\item{na_str}{(\code{string})\cr string that should be displayed when the value of \code{x} is missing. Defaults to \code{"NA"}.}

\item{nested}{(\code{logical})\cr whether this layout instruction should be applied within the existing layout structure
\emph{if possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split
underneath analyses, which is not allowed.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{inclNAs}{(\code{logical})\cr whether NA observations in the \code{var} variable(s) should be included when performing
the analysis. Defaults to \code{FALSE}.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
Generate rows analyzing different variables across columns
}
\examples{
library(dplyr)

ANL <- DM \%>\% mutate(value = rnorm(n()), pctdiff = runif(n()))

## toy example where we take the mean of the first variable and the
## count of >.5 for the second.
colfuns <- list(
  function(x) rcell(mean(x), format = "xx.x"),
  function(x) rcell(sum(x > .5), format = "xx")
)

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by_multivar(c("value", "pctdiff")) \%>\%
  split_rows_by("RACE",
    split_label = "ethnicity",
    split_fun = drop_split_levels
  ) \%>\%
  summarize_row_groups() \%>\%
  analyze_colvars(afun = colfuns)
lyt

tbl <- build_table(lyt, ANL)
tbl

lyt2 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by_multivar(c("value", "pctdiff"),
    varlabels = c("Measurement", "Pct Diff")
  ) \%>\%
  split_rows_by("RACE",
    split_label = "ethnicity",
    split_fun = drop_split_levels
  ) \%>\%
  summarize_row_groups() \%>\%
  analyze_colvars(afun = mean, format = "xx.xx")

tbl2 <- build_table(lyt2, ANL)
tbl2

}
\seealso{
\code{\link[=split_cols_by_multivar]{split_cols_by_multivar()}}
}
\author{
Gabriel Becker
}
