% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg_posts_search.R
\name{tg_posts_search}
\alias{tg_posts_search}
\title{Search publications}
\usage{
tg_posts_search(
  query,
  peer_type = c("all", "channel", "chat"),
  start_date = Sys.Date() - 15,
  end_date = Sys.Date(),
  hide_forwards = 0,
  hide_deleted = 0,
  strong_search = 0,
  minus_mords = NULL,
  extended_syntax = 0
)
}
\arguments{
\item{query}{Search query}

\item{peer_type}{Source type (channel, chat, all)}

\item{start_date}{Published date from (timestamp)}

\item{end_date}{Date published to (timestamp)}

\item{hide_forwards}{Hide reposts from search results}

\item{hide_deleted}{Hide deleted posts}

\item{strong_search}{Enable strict search (disables morphology and search by part of a word)}

\item{minus_mords}{List of negative words (separator - space)}

\item{extended_syntax}{Whether the request uses \href{https://api.tgstat.ru/docs/ru/extended-syntax.html}{extended query syntax}, see details}
}
\value{
list with two tibbles
}
\description{
Method for searching publications by keyword. Returns publications, sorted in reverse chronological order (most recent from the top), in which the search text was found.
}
\details{
Keyword / phrase search methods support extended query syntax. You must pass the extendedSyntax parameter (or extended_syntax in newer API methods) to indicate to the parser that the search query contains statements from the extended query language.

\strong{Morphology:}

Regardless of the form in which you used a word in a query, by default all its morphological forms are taken into account (in any case, singular and plural). That is, by request mom will also find publications in which mom, mom, mom, mom, etc. are found.
To change this behavior, you must use the \code{=} operator.

\strong{Exact occurrence of the word. Operator =}

The \code{=} operator in front of a word tells the analyzer that the given word should be searched for in an exact match with the transmitted one. The query \verb{=mom} will only find posts with the word mom. Publications containing the words mum, mum, mum, mum in the text will NOT be found.

\strong{Search by multiple words}

When transferring several words separated by spaces to a search query, publications will be found in which each of these words occurs at the same time.
The request mom dad will find publications in the text of which both of these words appear simultaneously in any order and case, at any distance from each other.

\strong{OR operator |}

If you need to find publications in which at least one of the words occurs, you must use the OR operator \code{|}.
Request \code{Mom | dad} will find publications in the text of which at least one of these words is found.

\strong{Search for a phrase. Operator ""}

The query \verb{mama washed the frame}, enclosed in double quotes, sets a strict word order, explaining to the analyzer that it needs to find the entire phrase passed. Only those publications will be found in which these three words appear side by side in the same order as specified in the request.
Publications containing these words in word forms other than those submitted will also be found. To change this behavior, you must use the \code{=} operator.
The \code{query = "mama soap frame"} will only find publications in which these three words appear side by side in the same order and in the same case as indicated in the query.

\strong{Using negative keywords. Operator -}

Using the operator \code{-} you can specify which words should not appear in the text of the publication. The query \code{"mama soap" -frame} will show publications that contain the phrases mummy soap, mummy washed, ..., but do not contain the words frame, frame, etc.

\strong{Grouping words. Operator ()}

Using parentheses in a search query allows you to group parts of a query and make more complex combinations using the operators described above.
The query \code{(mom | dad | brother | sister)} \code{(soap | painted)} \code{(frame | door)} will find publications in the text of which at least one word from each word group is necessarily found. Those. publications will be found containing: mom washed the frame, dad washed the frame, sister painted the door, etc.
The query \code{(mom | dad) (dyed) - (frame | door | hair)} will find publications, the text of which must contain at least one of the words of the first group mom, dad, it must contain a word from the second group painted, dyed, dyed, but not contains words from the last group frame, door, hair.

You can practice writing search queries in our \href{https://tgstat.ru/search}{publication search tool} (do not forget to check the "Advanced language" checkbox to enable the advanced query syntax mode).
}
\examples{
\dontrun{
post_search <- tg_posts_search(
    query = 'rtgstat package',
    peer_type = 'channel',
    start_date = '2021-11-01',
    end_date = '2021-11-31'
)

search_result <- post_search$items
channels <- post_search$channels

}
}
