% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_workhorse.R
\name{trim_estimate}
\alias{trim_estimate}
\title{TRIM estimation function}
\usage{
trim_estimate(count, site.id, time.id, covars = data.frame(), model = 2,
  serialcor = FALSE, overdisp = FALSE, changepoints = integer(0),
  autodelete = TRUE, weights = numeric(0), stepwise = FALSE,
  covin = list(), ...)
}
\arguments{
\item{count}{a numerical vector of count data.}

\item{site.id}{a numerical vector time points for each count data point.}

\item{time.id}{a numerical vector time points for each count data point.}

\item{covars}{an optional data frame with covariates}

\item{model}{a model type selector (1, 2 or 3)}

\item{serialcor}{a flag indication of autocorrelation has to be taken into account.}

\item{overdisp}{a flag indicating of overdispersion has to be taken into account.}

\item{changepoints}{a numerical vector change points (only for Model 2)}

\item{autodelete}{a flag indicating auto-deletion of changepoints with too little observations.}

\item{weights}{a numerical vector of weights.}

\item{stepwise}{a flag indicating stepwise refinement of changepoints is to be used.}
}
\value{
a list of class \code{trim}, that contains all output, statistiscs, etc.
  Usually this information is retrieved by a set of postprocessing functions
}
\description{
TRIM estimation function
}
\keyword{internal}

