// Generated by rstantools.  Do not edit by hand.

/*
    rts2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rts2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rts2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_approxlgcp_nngp_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 180> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 115, column 2 to column 55)",
  " (in 'string', line 116, column 2 to column 57)",
  " (in 'string', line 117, column 2 to column 18)",
  " (in 'string', line 118, column 2 to column 50)",
  " (in 'string', line 119, column 2 to column 27)",
  " (in 'string', line 122, column 2 to column 26)",
  " (in 'string', line 123, column 2 to column 24)",
  " (in 'string', line 124, column 2 to column 26)",
  " (in 'string', line 125, column 2 to column 23)",
  " (in 'string', line 172, column 2 to column 36)",
  " (in 'string', line 131, column 4 to column 27)",
  " (in 'string', line 132, column 4 to column 23)",
  " (in 'string', line 133, column 4 to column 55)",
  " (in 'string', line 130, column 9 to line 134, column 3)",
  " (in 'string', line 127, column 4 to column 23)",
  " (in 'string', line 128, column 4 to column 19)",
  " (in 'string', line 129, column 4 to column 17)",
  " (in 'string', line 126, column 15 to line 130, column 3)",
  " (in 'string', line 126, column 2 to line 134, column 3)",
  " (in 'string', line 144, column 6 to column 16)",
  " (in 'string', line 143, column 11 to line 145, column 5)",
  " (in 'string', line 141, column 8 to column 125)",
  " (in 'string', line 140, column 13 to line 142, column 7)",
  " (in 'string', line 139, column 8 to column 56)",
  " (in 'string', line 138, column 14 to line 140, column 7)",
  " (in 'string', line 138, column 6 to line 142, column 7)",
  " (in 'string', line 137, column 12 to line 143, column 5)",
  " (in 'string', line 137, column 4 to line 145, column 5)",
  " (in 'string', line 136, column 16 to line 146, column 3)",
  " (in 'string', line 136, column 2 to line 146, column 3)",
  " (in 'string', line 175, column 4 to column 60)",
  " (in 'string', line 174, column 26 to line 176, column 3)",
  " (in 'string', line 174, column 2 to line 176, column 3)",
  " (in 'string', line 150, column 4 to column 56)",
  " (in 'string', line 151, column 4 to column 52)",
  " (in 'string', line 149, column 16 to line 152, column 3)",
  " (in 'string', line 149, column 2 to line 152, column 3)",
  " (in 'string', line 154, column 10 to column 27)",
  " (in 'string', line 154, column 2 to column 27)",
  " (in 'string', line 156, column 4 to column 65)",
  " (in 'string', line 155, column 15 to line 157, column 3)",
  " (in 'string', line 155, column 2 to line 157, column 3)",
  " (in 'string', line 166, column 6 to column 60)",
  " (in 'string', line 165, column 11 to line 167, column 5)",
  " (in 'string', line 163, column 8 to column 93)",
  " (in 'string', line 162, column 13 to line 164, column 7)",
  " (in 'string', line 161, column 8 to column 73)",
  " (in 'string', line 160, column 14 to line 162, column 7)",
  " (in 'string', line 160, column 6 to line 164, column 7)",
  " (in 'string', line 159, column 12 to line 165, column 5)",
  " (in 'string', line 159, column 4 to line 167, column 5)",
  " (in 'string', line 158, column 16 to line 168, column 3)",
  " (in 'string', line 158, column 2 to line 168, column 3)",
  " (in 'string', line 169, column 2 to column 40)",
  " (in 'string', line 80, column 2 to column 17)",
  " (in 'string', line 81, column 2 to column 17)",
  " (in 'string', line 82, column 2 to column 17)",
  " (in 'string', line 83, column 2 to column 23)",
  " (in 'string', line 84, column 2 to column 9)",
  " (in 'string', line 85, column 8 to column 9)",
  " (in 'string', line 85, column 10 to column 17)",
  " (in 'string', line 85, column 2 to column 26)",
  " (in 'string', line 86, column 8 to column 18)",
  " (in 'string', line 86, column 2 to column 26)",
  " (in 'string', line 87, column 9 to column 16)",
  " (in 'string', line 87, column 17 to column 18)",
  " (in 'string', line 87, column 2 to column 27)",
  " (in 'string', line 88, column 9 to column 19)",
  " (in 'string', line 88, column 2 to column 29)",
  " (in 'string', line 89, column 9 to column 19)",
  " (in 'string', line 89, column 20 to column 21)",
  " (in 'string', line 89, column 2 to column 25)",
  " (in 'string', line 90, column 2 to column 29)",
  " (in 'string', line 91, column 2 to column 26)",
  " (in 'string', line 92, column 8 to column 9)",
  " (in 'string', line 92, column 2 to column 35)",
  " (in 'string', line 93, column 8 to column 9)",
  " (in 'string', line 93, column 2 to column 33)",
  " (in 'string', line 94, column 2 to column 10)",
  " (in 'string', line 95, column 2 to column 38)",
  " (in 'string', line 96, column 2 to column 27)",
  " (in 'string', line 97, column 2 to column 25)",
  " (in 'string', line 100, column 9 to column 19)",
  " (in 'string', line 100, column 2 to column 47)",
  " (in 'string', line 101, column 9 to column 28)",
  " (in 'string', line 101, column 29 to column 52)",
  " (in 'string', line 101, column 2 to column 62)",
  " (in 'string', line 102, column 8 to column 33)",
  " (in 'string', line 102, column 2 to column 46)",
  " (in 'string', line 105, column 6 to line 106, column 73)",
  " (in 'string', line 104, column 27 to line 107, column 5)",
  " (in 'string', line 104, column 4 to line 107, column 5)",
  " (in 'string', line 103, column 25 to line 108, column 3)",
  " (in 'string', line 103, column 2 to line 108, column 3)",
  " (in 'string', line 111, column 4 to column 70)",
  " (in 'string', line 110, column 15 to line 112, column 3)",
  " (in 'string', line 110, column 2 to line 112, column 3)",
  " (in 'string', line 115, column 8 to column 25)",
  " (in 'string', line 116, column 8 to column 25)",
  " (in 'string', line 117, column 9 to column 10)",
  " (in 'string', line 118, column 8 to column 22)",
  " (in 'string', line 119, column 9 to column 19)",
  " (in 'string', line 122, column 9 to column 13)",
  " (in 'string', line 122, column 14 to column 21)",
  " (in 'string', line 125, column 9 to column 19)",
  " (in 'string', line 172, column 9 to column 19)",
  " (in 'string', line 4, column 11 to column 14)",
  " (in 'string', line 4, column 15 to column 16)",
  " (in 'string', line 4, column 4 to column 43)",
  " (in 'string', line 5, column 4 to column 15)",
  " (in 'string', line 6, column 4 to column 13)",
  " (in 'string', line 7, column 4 to column 13)",
  " (in 'string', line 8, column 4 to column 14)",
  " (in 'string', line 9, column 4 to column 22)",
  " (in 'string', line 10, column 11 to column 12)",
  " (in 'string', line 10, column 13 to column 14)",
  " (in 'string', line 10, column 4 to column 41)",
  " (in 'string', line 11, column 11 to column 12)",
  " (in 'string', line 11, column 4 to column 37)",
  " (in 'string', line 12, column 4 to column 14)",
  " (in 'string', line 15, column 6 to column 32)",
  " (in 'string', line 17, column 8 to column 26)",
  " (in 'string', line 16, column 24 to line 18, column 7)",
  " (in 'string', line 16, column 6 to line 18, column 7)",
  " (in 'string', line 22, column 12 to column 57)",
  " (in 'string', line 23, column 12 to column 57)",
  " (in 'string', line 24, column 12 to column 77)",
  " (in 'string', line 25, column 12 to column 32)",
  " (in 'string', line 30, column 14 to column 55)",
  " (in 'string', line 31, column 14 to column 36)",
  " (in 'string', line 29, column 19 to line 32, column 13)",
  " (in 'string', line 27, column 14 to column 70)",
  " (in 'string', line 28, column 14 to column 36)",
  " (in 'string', line 26, column 24 to line 29, column 13)",
  " (in 'string', line 26, column 12 to line 32, column 13)",
  " (in 'string', line 21, column 32 to line 33, column 11)",
  " (in 'string', line 21, column 10 to line 33, column 11)",
  " (in 'string', line 20, column 30 to line 34, column 9)",
  " (in 'string', line 20, column 8 to line 34, column 9)",
  " (in 'string', line 19, column 20 to line 35, column 7)",
  " (in 'string', line 19, column 6 to line 35, column 7)",
  " (in 'string', line 37, column 8 to column 84)",
  " (in 'string', line 38, column 8 to column 28)",
  " (in 'string', line 39, column 8 to column 104)",
  " (in 'string', line 36, column 24 to line 40, column 7)",
  " (in 'string', line 36, column 6 to line 40, column 7)",
  " (in 'string', line 41, column 6 to column 82)",
  " (in 'string', line 42, column 6 to column 69)",
  " (in 'string', line 14, column 17 to line 43, column 5)",
  " (in 'string', line 14, column 4 to line 43, column 5)",
  " (in 'string', line 44, column 4 to column 15)",
  " (in 'string', line 3, column 62 to line 45, column 4)",
  " (in 'string', line 48, column 4 to column 21)",
  " (in 'string', line 49, column 4 to column 25)",
  " (in 'string', line 50, column 4 to column 17)",
  " (in 'string', line 51, column 4 to column 12)",
  " (in 'string', line 52, column 4 to column 12)",
  " (in 'string', line 53, column 4 to column 12)",
  " (in 'string', line 54, column 4 to column 15)",
  " (in 'string', line 58, column 6 to column 17)",
  " (in 'string', line 57, column 11 to line 59, column 5)",
  " (in 'string', line 56, column 6 to column 25)",
  " (in 'string', line 55, column 18 to line 57, column 5)",
  " (in 'string', line 55, column 4 to line 59, column 5)",
  " (in 'string', line 60, column 4 to column 16)",
  " (in 'string', line 62, column 6 to column 32)",
  " (in 'string', line 61, column 17 to line 63, column 5)",
  " (in 'string', line 61, column 4 to line 63, column 5)",
  " (in 'string', line 64, column 4 to column 29)",
  " (in 'string', line 66, column 6 to column 75)",
  " (in 'string', line 67, column 6 to column 28)",
  " (in 'string', line 69, column 8 to column 18)",
  " (in 'string', line 68, column 20 to line 70, column 7)",
  " (in 'string', line 68, column 6 to line 70, column 7)",
  " (in 'string', line 65, column 17 to line 71, column 5)",
  " (in 'string', line 65, column 4 to line 71, column 5)",
  " (in 'string', line 73, column 4 to column 51)",
  " (in 'string', line 74, column 4 to column 14)",
  " (in 'string', line 47, column 78 to line 75, column 4)"};
template <typename T0__, typename T1__, typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T4__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<T0__, T1__, T4__>,-1,-1>
getAD(const T0__& alpha, const T1__& theta, const int& M, const int& n,
      const std::vector<T4__>& dists, const std::vector<std::vector<int>>&
      NN, const int& mod, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>>* = nullptr>
stan::promote_args_t<T0__, stan::base_type_t<T1__>>
nngp_split_lpdf(const std::vector<T0__>& u, const T1__& AD_arg__,
                const std::vector<std::vector<int>>& NN, const int& start,
                std::ostream* pstream__);
template <typename T0__, typename T1__, typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T4__>>*>
Eigen::Matrix<stan::promote_args_t<T0__, T1__, T4__>,-1,-1>
getAD(const T0__& alpha, const T1__& theta, const int& M, const int& n,
      const std::vector<T4__>& dists, const std::vector<std::vector<int>>&
      NN, const int& mod, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T4__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 107;
    stan::math::validate_non_negative_index("AD", "M + 1", (M + 1));
    current_statement__ = 108;
    stan::math::validate_non_negative_index("AD", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,-1> AD =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant((M + 1), n,
        DUMMY_VAR__);
    current_statement__ = 109;
    stan::model::assign(AD, stan::math::rep_matrix(0, (M + 1), n),
      "assigning variable AD");
    int idxlim = std::numeric_limits<int>::min();
    int idx1 = std::numeric_limits<int>::min();
    int idx2 = std::numeric_limits<int>::min();
    local_scalar_t__ dist = DUMMY_VAR__;
    current_statement__ = 114;
    stan::model::assign(AD, alpha, "assigning variable AD",
      stan::model::index_uni((M + 1)), stan::model::index_uni(1));
    current_statement__ = 115;
    stan::math::validate_non_negative_index("smat", "M", M);
    current_statement__ = 116;
    stan::math::validate_non_negative_index("smat", "M", M);
    Eigen::Matrix<local_scalar_t__,-1,-1> smat =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(M, M, DUMMY_VAR__);
    current_statement__ = 117;
    stan::model::assign(smat, stan::math::rep_matrix(0, M, M),
      "assigning variable smat");
    current_statement__ = 118;
    stan::math::validate_non_negative_index("svec", "M", M);
    Eigen::Matrix<local_scalar_t__,-1,1> svec =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(M, DUMMY_VAR__);
    current_statement__ = 119;
    stan::model::assign(svec, stan::math::rep_vector(0, M),
      "assigning variable svec");
    int index = std::numeric_limits<int>::min();
    current_statement__ = 150;
    for (int i = 2; i <= n; ++i) {
      current_statement__ = 121;
      idxlim = (stan::math::logical_lte(i, M) ? (i - 1) : M);
      current_statement__ = 124;
      for (int j = 1; j <= idxlim; ++j) {
        current_statement__ = 122;
        stan::model::assign(smat, alpha, "assigning variable smat",
          stan::model::index_uni(j), stan::model::index_uni(j));
      }
      current_statement__ = 141;
      if (stan::math::logical_gt(idxlim, 1)) {
        current_statement__ = 139;
        for (int j = 1; j <= (idxlim - 1); ++j) {
          current_statement__ = 137;
          for (int k = (j + 1); k <= idxlim; ++k) {
            current_statement__ = 125;
            idx1 = (stan::math::logical_lt(
                      stan::model::rvalue(NN, "NN",
                        stan::model::index_uni(j), stan::model::index_uni(i)),
                      stan::model::rvalue(NN, "NN",
                        stan::model::index_uni(k), stan::model::index_uni(i))) ? 
              stan::model::rvalue(NN, "NN", stan::model::index_uni(j),
                stan::model::index_uni(i)) : stan::model::rvalue(NN, "NN",
                                               stan::model::index_uni(k),
                                               stan::model::index_uni(i)));
            current_statement__ = 126;
            idx2 = (stan::math::logical_lt(
                      stan::model::rvalue(NN, "NN",
                        stan::model::index_uni(j), stan::model::index_uni(i)),
                      stan::model::rvalue(NN, "NN",
                        stan::model::index_uni(k), stan::model::index_uni(i))) ? 
              stan::model::rvalue(NN, "NN", stan::model::index_uni(k),
                stan::model::index_uni(i)) : stan::model::rvalue(NN, "NN",
                                               stan::model::index_uni(j),
                                               stan::model::index_uni(i)));
            current_statement__ = 127;
            index = (((((n - 1) * (idx1 - 1)) - (((idx1 - 2) * (idx1 - 1)) /
              2)) + ((idx2 - idx1) - 1)) + 1);
            current_statement__ = 128;
            dist = stan::model::rvalue(dists, "dists",
                     stan::model::index_uni(index));
            current_statement__ = 135;
            if (stan::math::logical_eq(mod, 0)) {
              current_statement__ = 132;
              stan::model::assign(smat, (alpha *
                stan::math::exp(((-1.0 * (dist * dist)) / (theta * theta)))),
                "assigning variable smat", stan::model::index_uni(j),
                stan::model::index_uni(k));
              current_statement__ = 133;
              stan::model::assign(smat,
                stan::model::rvalue(smat, "smat", stan::model::index_uni(j),
                  stan::model::index_uni(k)), "assigning variable smat",
                stan::model::index_uni(k), stan::model::index_uni(j));
            } else {
              current_statement__ = 129;
              stan::model::assign(smat, (alpha *
                stan::math::exp(((-1.0 * dist) / theta))),
                "assigning variable smat", stan::model::index_uni(j),
                stan::model::index_uni(k));
              current_statement__ = 130;
              stan::model::assign(smat,
                stan::model::rvalue(smat, "smat", stan::model::index_uni(j),
                  stan::model::index_uni(k)), "assigning variable smat",
                stan::model::index_uni(k), stan::model::index_uni(j));
            }
          }
        }
      }
      current_statement__ = 146;
      for (int j = 1; j <= idxlim; ++j) {
        current_statement__ = 142;
        index = (((((n - 1) *
          (stan::model::rvalue(NN, "NN", stan::model::index_uni(j),
             stan::model::index_uni(i))
          - 1)) -
          (((stan::model::rvalue(NN, "NN", stan::model::index_uni(j),
               stan::model::index_uni(i))
          - 2) *
          (stan::model::rvalue(NN, "NN", stan::model::index_uni(j),
             stan::model::index_uni(i))
          - 1)) / 2)) + ((i -
          stan::model::rvalue(NN, "NN", stan::model::index_uni(j),
            stan::model::index_uni(i)))
          - 1)) + 1);
        current_statement__ = 143;
        dist = stan::model::rvalue(dists, "dists",
                 stan::model::index_uni(index));
        current_statement__ = 144;
        stan::model::assign(svec, (stan::math::logical_eq(mod, 0) ? (alpha *
          stan::math::exp(((-1.0 * (dist * dist)) / (theta * theta)))) : (alpha
          * stan::math::exp(((-1.0 * dist) / theta)))),
          "assigning variable svec", stan::model::index_uni(j));
      }
      current_statement__ = 147;
      stan::model::assign(AD,
        stan::math::mdivide_left_spd(
          stan::model::rvalue(smat, "smat",
            stan::model::index_min_max(1, idxlim),
            stan::model::index_min_max(1, idxlim)),
          stan::model::rvalue(svec, "svec",
            stan::model::index_min_max(1, idxlim))), "assigning variable AD",
        stan::model::index_min_max(1, idxlim), stan::model::index_uni(i));
      current_statement__ = 148;
      stan::model::assign(AD, (alpha -
        stan::math::dot_product(
          stan::model::rvalue(AD, "AD",
            stan::model::index_min_max(1, idxlim), stan::model::index_uni(i)),
          stan::model::rvalue(svec, "svec",
            stan::model::index_min_max(1, idxlim)))),
        "assigning variable AD", stan::model::index_uni((M + 1)),
        stan::model::index_uni(i));
    }
    current_statement__ = 151;
    return AD;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>>*>
stan::promote_args_t<T0__, stan::base_type_t<T1__>>
nngp_split_lpdf(const std::vector<T0__>& u, const T1__& AD_arg__,
                const std::vector<std::vector<int>>& NN, const int& start,
                std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
                             stan::base_type_t<T1__>>;
  int current_statement__ = 0;
  const auto& AD = stan::math::to_ref(AD_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n = std::numeric_limits<int>::min();
    current_statement__ = 153;
    n = stan::math::cols(AD);
    int M = std::numeric_limits<int>::min();
    current_statement__ = 154;
    M = (stan::math::rows(AD) - 1);
    local_scalar_t__ logdetD = DUMMY_VAR__;
    local_scalar_t__ qf = DUMMY_VAR__;
    local_scalar_t__ au = DUMMY_VAR__;
    local_scalar_t__ ll = DUMMY_VAR__;
    int idxlim = std::numeric_limits<int>::min();
    current_statement__ = 164;
    if (stan::math::logical_lte(start, M)) {
      current_statement__ = 162;
      idxlim = (start - 1);
    } else {
      current_statement__ = 160;
      idxlim = M;
    }
    current_statement__ = 165;
    logdetD = 0;
    current_statement__ = 168;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 166;
      logdetD = (logdetD +
        stan::math::log(
          stan::model::rvalue(AD, "AD", stan::model::index_uni((M + 1)),
            stan::model::index_uni(i))));
    }
    current_statement__ = 169;
    qf = ((stan::model::rvalue(u, "u", stan::model::index_uni(1)) *
      stan::model::rvalue(u, "u", stan::model::index_uni(1))) /
      stan::model::rvalue(AD, "AD", stan::model::index_uni((M + 1)),
        stan::model::index_uni(1)));
    current_statement__ = 176;
    for (int i = 2; i <= n; ++i) {
      current_statement__ = 170;
      au = (stan::model::rvalue(u, "u", stan::model::index_uni(i)) -
        stan::math::dot_product(
          stan::model::rvalue(AD, "AD",
            stan::model::index_min_max(1, idxlim), stan::model::index_uni(i)),
          stan::math::to_vector(
            stan::model::rvalue(u, "u",
              stan::model::index_multi(
                stan::model::rvalue(NN, "NN",
                  stan::model::index_min_max(1, idxlim),
                  stan::model::index_uni(i)))))));
      current_statement__ = 171;
      qf = (qf + ((au * au) /
        stan::model::rvalue(AD, "AD", stan::model::index_uni((M + 1)),
          stan::model::index_uni(i))));
      current_statement__ = 174;
      if (stan::math::logical_lt(idxlim, M)) {
        current_statement__ = 172;
        idxlim = (idxlim + 1);
      }
    }
    current_statement__ = 177;
    ll = (((-0.5 * logdetD) - (0.5 * qf)) - ((0.5 * n) *
      stan::math::log((2 * stan::math::pi()))));
    current_statement__ = 178;
    return ll;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_approxlgcp_nngp final : public model_base_crtp<model_approxlgcp_nngp> {
private:
  int D;
  int Q;
  int M;
  int Nsample;
  int nT;
  std::vector<std::vector<int>> NN;
  std::vector<int> y;
  Eigen::Matrix<double,-1,-1> x_grid_data__;
  Eigen::Matrix<double,-1,1> popdens_data__;
  Eigen::Matrix<double,-1,-1> X_data__;
  std::vector<double> prior_lscale;
  std::vector<double> prior_var;
  std::vector<double> prior_linpred_mean;
  std::vector<double> prior_linpred_sd;
  int mod;
  int known_cov;
  double sigma_data;
  double phi_data;
  Eigen::Matrix<double,-1,1> logpopdens_data__;
  Eigen::Matrix<double,-1,-1> AD_data_data__;
  std::vector<double> dists;
  int phi_param_1dim__;
  int sigma_param_1dim__;
  int ar_1dim__;
  int f_raw_1dim__;
  int AD_1dim__;
  int f_1dim__;
  int y_grid_predict_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> x_grid{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> popdens{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> logpopdens{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> AD_data{nullptr, 0, 0};
public:
  ~model_approxlgcp_nngp() {}
  model_approxlgcp_nngp(stan::io::var_context& context__, unsigned int
                        random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_approxlgcp_nngp_namespace::model_approxlgcp_nngp";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 55;
      context__.validate_dims("data initialization", "D", "int",
        std::vector<size_t>{});
      D = std::numeric_limits<int>::min();
      current_statement__ = 55;
      D = context__.vals_i("D")[(1 - 1)];
      current_statement__ = 55;
      stan::math::check_greater_or_equal(function__, "D", D, 1);
      current_statement__ = 56;
      context__.validate_dims("data initialization", "Q", "int",
        std::vector<size_t>{});
      Q = std::numeric_limits<int>::min();
      current_statement__ = 56;
      Q = context__.vals_i("Q")[(1 - 1)];
      current_statement__ = 56;
      stan::math::check_greater_or_equal(function__, "Q", Q, 1);
      current_statement__ = 57;
      context__.validate_dims("data initialization", "M", "int",
        std::vector<size_t>{});
      M = std::numeric_limits<int>::min();
      current_statement__ = 57;
      M = context__.vals_i("M")[(1 - 1)];
      current_statement__ = 57;
      stan::math::check_greater_or_equal(function__, "M", M, 1);
      current_statement__ = 58;
      context__.validate_dims("data initialization", "Nsample", "int",
        std::vector<size_t>{});
      Nsample = std::numeric_limits<int>::min();
      current_statement__ = 58;
      Nsample = context__.vals_i("Nsample")[(1 - 1)];
      current_statement__ = 58;
      stan::math::check_greater_or_equal(function__, "Nsample", Nsample, 1);
      current_statement__ = 59;
      context__.validate_dims("data initialization", "nT", "int",
        std::vector<size_t>{});
      nT = std::numeric_limits<int>::min();
      current_statement__ = 59;
      nT = context__.vals_i("nT")[(1 - 1)];
      current_statement__ = 60;
      stan::math::validate_non_negative_index("NN", "M", M);
      current_statement__ = 61;
      stan::math::validate_non_negative_index("NN", "Nsample", Nsample);
      current_statement__ = 62;
      context__.validate_dims("data initialization", "NN", "int",
        std::vector<size_t>{static_cast<size_t>(M),
          static_cast<size_t>(Nsample)});
      NN = std::vector<std::vector<int>>(M,
             std::vector<int>(Nsample, std::numeric_limits<int>::min()));
      {
        std::vector<int> NN_flat__;
        current_statement__ = 62;
        NN_flat__ = context__.vals_i("NN");
        current_statement__ = 62;
        pos__ = 1;
        current_statement__ = 62;
        for (int sym1__ = 1; sym1__ <= Nsample; ++sym1__) {
          current_statement__ = 62;
          for (int sym2__ = 1; sym2__ <= M; ++sym2__) {
            current_statement__ = 62;
            stan::model::assign(NN, NN_flat__[(pos__ - 1)],
              "assigning variable NN", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 62;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 63;
      stan::math::validate_non_negative_index("y", "Nsample * nT", (Nsample *
        nT));
      current_statement__ = 64;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>((Nsample * nT))});
      y = std::vector<int>((Nsample * nT), std::numeric_limits<int>::min());
      current_statement__ = 64;
      y = context__.vals_i("y");
      current_statement__ = 65;
      stan::math::validate_non_negative_index("x_grid", "Nsample", Nsample);
      current_statement__ = 66;
      stan::math::validate_non_negative_index("x_grid", "D", D);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "x_grid", "double",
        std::vector<size_t>{static_cast<size_t>(Nsample),
          static_cast<size_t>(D)});
      x_grid_data__ = Eigen::Matrix<double,-1,-1>::Constant(Nsample, D,
                        std::numeric_limits<double>::quiet_NaN());
      new (&x_grid)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(x_grid_data__.data(),
        Nsample, D);
      {
        std::vector<local_scalar_t__> x_grid_flat__;
        current_statement__ = 67;
        x_grid_flat__ = context__.vals_r("x_grid");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= D; ++sym1__) {
          current_statement__ = 67;
          for (int sym2__ = 1; sym2__ <= Nsample; ++sym2__) {
            current_statement__ = 67;
            stan::model::assign(x_grid, x_grid_flat__[(pos__ - 1)],
              "assigning variable x_grid", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 67;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 68;
      stan::math::validate_non_negative_index("popdens", "Nsample * nT",
        (Nsample * nT));
      current_statement__ = 69;
      context__.validate_dims("data initialization", "popdens", "double",
        std::vector<size_t>{static_cast<size_t>((Nsample * nT))});
      popdens_data__ = Eigen::Matrix<double,-1,1>::Constant((Nsample * nT),
                         std::numeric_limits<double>::quiet_NaN());
      new (&popdens)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(popdens_data__.data(),
        (Nsample * nT));
      {
        std::vector<local_scalar_t__> popdens_flat__;
        current_statement__ = 69;
        popdens_flat__ = context__.vals_r("popdens");
        current_statement__ = 69;
        pos__ = 1;
        current_statement__ = 69;
        for (int sym1__ = 1; sym1__ <= (Nsample * nT); ++sym1__) {
          current_statement__ = 69;
          stan::model::assign(popdens, popdens_flat__[(pos__ - 1)],
            "assigning variable popdens", stan::model::index_uni(sym1__));
          current_statement__ = 69;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 70;
      stan::math::validate_non_negative_index("X", "Nsample * nT", (Nsample *
        nT));
      current_statement__ = 71;
      stan::math::validate_non_negative_index("X", "Q", Q);
      current_statement__ = 72;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>((Nsample * nT)),
          static_cast<size_t>(Q)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant((Nsample * nT), Q,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(),
        (Nsample * nT), Q);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 72;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 72;
        pos__ = 1;
        current_statement__ = 72;
        for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
          current_statement__ = 72;
          for (int sym2__ = 1; sym2__ <= (Nsample * nT); ++sym2__) {
            current_statement__ = 72;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 72;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 73;
      context__.validate_dims("data initialization", "prior_lscale",
        "double", std::vector<size_t>{static_cast<size_t>(2)});
      prior_lscale = std::vector<double>(2,
                       std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 73;
      prior_lscale = context__.vals_r("prior_lscale");
      current_statement__ = 74;
      context__.validate_dims("data initialization", "prior_var", "double",
        std::vector<size_t>{static_cast<size_t>(2)});
      prior_var = std::vector<double>(2,
                    std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 74;
      prior_var = context__.vals_r("prior_var");
      current_statement__ = 75;
      stan::math::validate_non_negative_index("prior_linpred_mean", "Q", Q);
      current_statement__ = 76;
      context__.validate_dims("data initialization", "prior_linpred_mean",
        "double", std::vector<size_t>{static_cast<size_t>(Q)});
      prior_linpred_mean = std::vector<double>(Q,
                             std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 76;
      prior_linpred_mean = context__.vals_r("prior_linpred_mean");
      current_statement__ = 77;
      stan::math::validate_non_negative_index("prior_linpred_sd", "Q", Q);
      current_statement__ = 78;
      context__.validate_dims("data initialization", "prior_linpred_sd",
        "double", std::vector<size_t>{static_cast<size_t>(Q)});
      prior_linpred_sd = std::vector<double>(Q,
                           std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 78;
      prior_linpred_sd = context__.vals_r("prior_linpred_sd");
      current_statement__ = 79;
      context__.validate_dims("data initialization", "mod", "int",
        std::vector<size_t>{});
      mod = std::numeric_limits<int>::min();
      current_statement__ = 79;
      mod = context__.vals_i("mod")[(1 - 1)];
      current_statement__ = 80;
      context__.validate_dims("data initialization", "known_cov", "int",
        std::vector<size_t>{});
      known_cov = std::numeric_limits<int>::min();
      current_statement__ = 80;
      known_cov = context__.vals_i("known_cov")[(1 - 1)];
      current_statement__ = 80;
      stan::math::check_greater_or_equal(function__, "known_cov", known_cov,
        0);
      current_statement__ = 80;
      stan::math::check_less_or_equal(function__, "known_cov", known_cov, 1);
      current_statement__ = 81;
      context__.validate_dims("data initialization", "sigma_data", "double",
        std::vector<size_t>{});
      sigma_data = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 81;
      sigma_data = context__.vals_r("sigma_data")[(1 - 1)];
      current_statement__ = 81;
      stan::math::check_greater_or_equal(function__, "sigma_data",
        sigma_data, 0);
      current_statement__ = 82;
      context__.validate_dims("data initialization", "phi_data", "double",
        std::vector<size_t>{});
      phi_data = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 82;
      phi_data = context__.vals_r("phi_data")[(1 - 1)];
      current_statement__ = 82;
      stan::math::check_greater_or_equal(function__, "phi_data", phi_data, 0);
      current_statement__ = 83;
      stan::math::validate_non_negative_index("logpopdens", "Nsample * nT",
        (Nsample * nT));
      current_statement__ = 84;
      logpopdens_data__ = Eigen::Matrix<double,-1,1>::Constant((Nsample *
                            nT), std::numeric_limits<double>::quiet_NaN());
      new (&logpopdens)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(logpopdens_data__.data(),
        (Nsample * nT));
      current_statement__ = 84;
      stan::model::assign(logpopdens, stan::math::log(popdens),
        "assigning variable logpopdens");
      current_statement__ = 85;
      stan::math::validate_non_negative_index("AD_data",
        "known_cov ? M + 1 : 0", (known_cov ? (M + 1) : 0));
      current_statement__ = 86;
      stan::math::validate_non_negative_index("AD_data",
        "known_cov ? Nsample : 0", (known_cov ? Nsample : 0));
      current_statement__ = 87;
      AD_data_data__ = Eigen::Matrix<double,-1,-1>::Constant((known_cov ? (M
                         + 1) : 0), (known_cov ? Nsample : 0),
                         std::numeric_limits<double>::quiet_NaN());
      new (&AD_data)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(AD_data_data__.data(),
        (known_cov ? (M + 1) : 0), (known_cov ? Nsample : 0));
      current_statement__ = 88;
      stan::math::validate_non_negative_index("dists",
        "(Nsample * (Nsample - 1)) %/% 2", ((Nsample * (Nsample - 1)) / 2));
      current_statement__ = 89;
      dists = std::vector<double>(((Nsample * (Nsample - 1)) / 2),
                std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 94;
      for (int i = 1; i <= (Nsample - 1); ++i) {
        current_statement__ = 92;
        for (int j = (i + 1); j <= Nsample; ++j) {
          current_statement__ = 90;
          stan::model::assign(dists,
            stan::math::sqrt(
              (((stan::model::rvalue(x_grid, "x_grid",
                   stan::model::index_uni(i), stan::model::index_uni(1)) -
              stan::model::rvalue(x_grid, "x_grid",
                stan::model::index_uni(j), stan::model::index_uni(1))) *
              (stan::model::rvalue(x_grid, "x_grid",
                 stan::model::index_uni(i), stan::model::index_uni(1)) -
              stan::model::rvalue(x_grid, "x_grid",
                stan::model::index_uni(j), stan::model::index_uni(1)))) +
              ((stan::model::rvalue(x_grid, "x_grid",
                  stan::model::index_uni(i), stan::model::index_uni(2)) -
              stan::model::rvalue(x_grid, "x_grid",
                stan::model::index_uni(j), stan::model::index_uni(2))) *
              (stan::model::rvalue(x_grid, "x_grid",
                 stan::model::index_uni(i), stan::model::index_uni(2)) -
              stan::model::rvalue(x_grid, "x_grid",
                stan::model::index_uni(j), stan::model::index_uni(2)))))),
            "assigning variable dists",
            stan::model::index_uni((((((Nsample - 1) * (i - 1)) - (((i - 2) *
              (i - 1)) / 2)) + ((j - i) - 1)) + 1)));
        }
      }
      current_statement__ = 97;
      if (known_cov) {
        current_statement__ = 95;
        stan::model::assign(AD_data,
          getAD(sigma_data, phi_data, M, Nsample, dists, NN, mod, pstream__),
          "assigning variable AD_data");
      }
      current_statement__ = 98;
      phi_param_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 98;
      phi_param_1dim__ = (known_cov ? 0 : 1);
      current_statement__ = 98;
      stan::math::validate_non_negative_index("phi_param",
        "known_cov ? 0 : 1", phi_param_1dim__);
      current_statement__ = 99;
      sigma_param_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 99;
      sigma_param_1dim__ = (known_cov ? 0 : 1);
      current_statement__ = 99;
      stan::math::validate_non_negative_index("sigma_param",
        "known_cov ? 0 : 1", sigma_param_1dim__);
      current_statement__ = 100;
      stan::math::validate_non_negative_index("gamma", "Q", Q);
      current_statement__ = 101;
      ar_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 101;
      ar_1dim__ = (stan::math::logical_gt(nT, 1) ? 1 : 0);
      current_statement__ = 101;
      stan::math::validate_non_negative_index("ar", "nT > 1 ? 1 : 0",
        ar_1dim__);
      current_statement__ = 102;
      f_raw_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 102;
      f_raw_1dim__ = (Nsample * nT);
      current_statement__ = 102;
      stan::math::validate_non_negative_index("f_raw", "Nsample * nT",
        f_raw_1dim__);
      current_statement__ = 103;
      AD_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 103;
      AD_1dim__ = (M + 1);
      current_statement__ = 103;
      stan::math::validate_non_negative_index("AD", "M + 1", AD_1dim__);
      current_statement__ = 104;
      stan::math::validate_non_negative_index("AD", "Nsample", Nsample);
      current_statement__ = 105;
      f_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 105;
      f_1dim__ = (Nsample * nT);
      current_statement__ = 105;
      stan::math::validate_non_negative_index("f", "Nsample * nT", f_1dim__);
      current_statement__ = 106;
      y_grid_predict_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 106;
      y_grid_predict_1dim__ = (Nsample * nT);
      current_statement__ = 106;
      stan::math::validate_non_negative_index("y_grid_predict",
        "Nsample * nT", y_grid_predict_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = phi_param_1dim__ + sigma_param_1dim__ + Q + ar_1dim__ +
      f_raw_1dim__;
  }
  inline std::string model_name() const final {
    return "model_approxlgcp_nngp";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_approxlgcp_nngp_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<local_scalar_t__> phi_param =
        std::vector<local_scalar_t__>(phi_param_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      phi_param = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(1e-05, lp__,
                    phi_param_1dim__);
      std::vector<local_scalar_t__> sigma_param =
        std::vector<local_scalar_t__>(sigma_param_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      sigma_param = in__.template read_constrain_lb<
                      std::vector<local_scalar_t__>, jacobian__>(1e-05, lp__,
                      sigma_param_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(Q, DUMMY_VAR__);
      current_statement__ = 3;
      gamma = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(Q);
      std::vector<local_scalar_t__> ar =
        std::vector<local_scalar_t__>(ar_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      ar = in__.template read_constrain_lub<std::vector<local_scalar_t__>,
             jacobian__>(-1, 1, lp__, ar_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,1> f_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(f_raw_1dim__,
          DUMMY_VAR__);
      current_statement__ = 5;
      f_raw = in__.template read<
                Eigen::Matrix<local_scalar_t__,-1,1>>(f_raw_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,-1> AD =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(AD_1dim__, Nsample,
          DUMMY_VAR__);
      local_scalar_t__ phi = DUMMY_VAR__;
      local_scalar_t__ sigma = DUMMY_VAR__;
      Eigen::Matrix<local_scalar_t__,-1,1> f =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(f_1dim__, DUMMY_VAR__);
      current_statement__ = 19;
      if (known_cov) {
        current_statement__ = 15;
        sigma = sigma_data;
        current_statement__ = 16;
        phi = phi_data;
        current_statement__ = 17;
        stan::model::assign(AD, AD_data, "assigning variable AD");
      } else {
        current_statement__ = 11;
        sigma = stan::model::rvalue(sigma_param, "sigma_param",
                  stan::model::index_uni(1));
        current_statement__ = 12;
        phi = stan::model::rvalue(phi_param, "phi_param",
                stan::model::index_uni(1));
        current_statement__ = 13;
        stan::model::assign(AD,
          getAD(sigma, phi, M, Nsample, dists, NN, mod, pstream__),
          "assigning variable AD");
      }
      current_statement__ = 30;
      for (int t = 1; t <= nT; ++t) {
        current_statement__ = 28;
        if (stan::math::logical_gt(nT, 1)) {
          current_statement__ = 26;
          if (stan::math::logical_eq(t, 1)) {
            current_statement__ = 24;
            stan::model::assign(f,
              stan::math::multiply((1 / (1 -
                stan::math::pow(
                  stan::model::rvalue(ar, "ar", stan::model::index_uni(1)), 2))),
                stan::model::rvalue(f_raw, "f_raw",
                  stan::model::index_min_max(1, Nsample))),
              "assigning variable f", stan::model::index_min_max(1, Nsample));
          } else {
            current_statement__ = 22;
            stan::model::assign(f,
              stan::math::add(
                stan::math::multiply(
                  stan::model::rvalue(ar, "ar", stan::model::index_uni(1)),
                  stan::model::deep_copy(
                    stan::model::rvalue(f, "f",
                      stan::model::index_min_max(((Nsample * (t - 2)) + 1),
                        ((t - 1) * Nsample))))),
                stan::model::rvalue(f_raw, "f_raw",
                  stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t *
                    Nsample)))), "assigning variable f",
              stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t *
                Nsample)));
          }
        } else {
          current_statement__ = 20;
          stan::model::assign(f, f_raw, "assigning variable f");
        }
      }
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "phi", phi, 1e-05);
      current_statement__ = 8;
      stan::math::check_greater_or_equal(function__, "sigma", sigma, 1e-05);
      {
        current_statement__ = 37;
        if (stan::math::logical_negation(known_cov)) {
          current_statement__ = 34;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(phi_param,
                           stan::model::rvalue(prior_lscale, "prior_lscale",
                             stan::model::index_uni(1)),
                           stan::model::rvalue(prior_lscale, "prior_lscale",
                             stan::model::index_uni(2))));
          current_statement__ = 35;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(sigma_param,
                           stan::model::rvalue(prior_var, "prior_var",
                             stan::model::index_uni(1)),
                           stan::model::rvalue(prior_var, "prior_var",
                             stan::model::index_uni(2))));
        }
        current_statement__ = 39;
        if (stan::math::logical_gt(nT, 1)) {
          current_statement__ = 38;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(ar, 0, 1));
        }
        current_statement__ = 42;
        for (int q = 1; q <= Q; ++q) {
          current_statement__ = 40;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(
                           stan::model::rvalue(gamma, "gamma",
                             stan::model::index_uni(q)),
                           stan::model::rvalue(prior_linpred_mean,
                             "prior_linpred_mean", stan::model::index_uni(q)),
                           stan::model::rvalue(prior_linpred_sd,
                             "prior_linpred_sd", stan::model::index_uni(q))));
        }
        current_statement__ = 53;
        for (int t = 1; t <= nT; ++t) {
          current_statement__ = 51;
          if (stan::math::logical_gt(nT, 1)) {
            current_statement__ = 49;
            if (stan::math::logical_eq(t, 1)) {
              current_statement__ = 47;
              lp_accum__.add(nngp_split_lpdf<false>(
                               stan::math::to_array_1d(
                                 stan::model::rvalue(f_raw, "f_raw",
                                   stan::model::index_min_max(1, Nsample))),
                               AD, NN, 1, pstream__));
            } else {
              current_statement__ = 45;
              lp_accum__.add(nngp_split_lpdf<false>(
                               stan::math::to_array_1d(
                                 stan::model::rvalue(f_raw, "f_raw",
                                   stan::model::index_min_max(((Nsample * (t
                                     - 1)) + 1), (t * Nsample)))), AD, NN, 1,
                               pstream__));
            }
          } else {
            current_statement__ = 43;
            lp_accum__.add(nngp_split_lpdf<false>(
                             stan::math::to_array_1d(f_raw), AD, NN, 1,
                             pstream__));
          }
        }
        current_statement__ = 54;
        lp_accum__.add(stan::math::poisson_log_lpmf<propto__>(y,
                         stan::math::add(
                           stan::math::add(stan::math::multiply(X, gamma),
                             logpopdens), f)));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_approxlgcp_nngp_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<double> phi_param =
        std::vector<double>(phi_param_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      phi_param = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(1e-05, lp__,
                    phi_param_1dim__);
      std::vector<double> sigma_param =
        std::vector<double>(sigma_param_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      sigma_param = in__.template read_constrain_lb<
                      std::vector<local_scalar_t__>, jacobian__>(1e-05, lp__,
                      sigma_param_1dim__);
      Eigen::Matrix<double,-1,1> gamma =
        Eigen::Matrix<double,-1,1>::Constant(Q,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      gamma = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(Q);
      std::vector<double> ar =
        std::vector<double>(ar_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      ar = in__.template read_constrain_lub<std::vector<local_scalar_t__>,
             jacobian__>(-1, 1, lp__, ar_1dim__);
      Eigen::Matrix<double,-1,1> f_raw =
        Eigen::Matrix<double,-1,1>::Constant(f_raw_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      f_raw = in__.template read<
                Eigen::Matrix<local_scalar_t__,-1,1>>(f_raw_1dim__);
      Eigen::Matrix<double,-1,-1> AD =
        Eigen::Matrix<double,-1,-1>::Constant(AD_1dim__, Nsample,
          std::numeric_limits<double>::quiet_NaN());
      double phi = std::numeric_limits<double>::quiet_NaN();
      double sigma = std::numeric_limits<double>::quiet_NaN();
      Eigen::Matrix<double,-1,1> f =
        Eigen::Matrix<double,-1,1>::Constant(f_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(phi_param);
      out__.write(sigma_param);
      out__.write(gamma);
      out__.write(ar);
      out__.write(f_raw);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 19;
      if (known_cov) {
        current_statement__ = 15;
        sigma = sigma_data;
        current_statement__ = 16;
        phi = phi_data;
        current_statement__ = 17;
        stan::model::assign(AD, AD_data, "assigning variable AD");
      } else {
        current_statement__ = 11;
        sigma = stan::model::rvalue(sigma_param, "sigma_param",
                  stan::model::index_uni(1));
        current_statement__ = 12;
        phi = stan::model::rvalue(phi_param, "phi_param",
                stan::model::index_uni(1));
        current_statement__ = 13;
        stan::model::assign(AD,
          getAD(sigma, phi, M, Nsample, dists, NN, mod, pstream__),
          "assigning variable AD");
      }
      current_statement__ = 30;
      for (int t = 1; t <= nT; ++t) {
        current_statement__ = 28;
        if (stan::math::logical_gt(nT, 1)) {
          current_statement__ = 26;
          if (stan::math::logical_eq(t, 1)) {
            current_statement__ = 24;
            stan::model::assign(f,
              stan::math::multiply((1 / (1 -
                stan::math::pow(
                  stan::model::rvalue(ar, "ar", stan::model::index_uni(1)), 2))),
                stan::model::rvalue(f_raw, "f_raw",
                  stan::model::index_min_max(1, Nsample))),
              "assigning variable f", stan::model::index_min_max(1, Nsample));
          } else {
            current_statement__ = 22;
            stan::model::assign(f,
              stan::math::add(
                stan::math::multiply(
                  stan::model::rvalue(ar, "ar", stan::model::index_uni(1)),
                  stan::model::deep_copy(
                    stan::model::rvalue(f, "f",
                      stan::model::index_min_max(((Nsample * (t - 2)) + 1),
                        ((t - 1) * Nsample))))),
                stan::model::rvalue(f_raw, "f_raw",
                  stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t *
                    Nsample)))), "assigning variable f",
              stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t *
                Nsample)));
          }
        } else {
          current_statement__ = 20;
          stan::model::assign(f, f_raw, "assigning variable f");
        }
      }
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "phi", phi, 1e-05);
      current_statement__ = 8;
      stan::math::check_greater_or_equal(function__, "sigma", sigma, 1e-05);
      if (emit_transformed_parameters__) {
        out__.write(AD);
        out__.write(phi);
        out__.write(sigma);
        out__.write(f);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> y_grid_predict =
        Eigen::Matrix<double,-1,1>::Constant(y_grid_predict_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 33;
      for (int i = 1; i <= (Nsample * nT); ++i) {
        current_statement__ = 31;
        stan::model::assign(y_grid_predict,
          stan::math::exp(
            ((stan::math::multiply(
                stan::model::rvalue(X, "X", stan::model::index_uni(i),
                  stan::model::index_omni()), gamma) +
            stan::model::rvalue(logpopdens, "logpopdens",
              stan::model::index_uni(i))) +
            stan::model::rvalue(f, "f", stan::model::index_uni(i)))),
          "assigning variable y_grid_predict", stan::model::index_uni(i));
      }
      out__.write(y_grid_predict);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> phi_param =
        std::vector<local_scalar_t__>(phi_param_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(phi_param,
        in__.read<std::vector<local_scalar_t__>>(phi_param_1dim__),
        "assigning variable phi_param");
      out__.write_free_lb(1e-05, phi_param);
      std::vector<local_scalar_t__> sigma_param =
        std::vector<local_scalar_t__>(sigma_param_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(sigma_param,
        in__.read<std::vector<local_scalar_t__>>(sigma_param_1dim__),
        "assigning variable sigma_param");
      out__.write_free_lb(1e-05, sigma_param);
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(Q, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(gamma,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(Q),
        "assigning variable gamma");
      out__.write(gamma);
      std::vector<local_scalar_t__> ar =
        std::vector<local_scalar_t__>(ar_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(ar,
        in__.read<std::vector<local_scalar_t__>>(ar_1dim__),
        "assigning variable ar");
      out__.write_free_lub(-1, 1, ar);
      Eigen::Matrix<local_scalar_t__,-1,1> f_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(f_raw_1dim__,
          DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(f_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(f_raw_1dim__),
        "assigning variable f_raw");
      out__.write(f_raw);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "phi_param",
        "double", std::vector<size_t>{static_cast<size_t>(phi_param_1dim__)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma_param",
        "double",
        std::vector<size_t>{static_cast<size_t>(sigma_param_1dim__)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "gamma", "double",
        std::vector<size_t>{static_cast<size_t>(Q)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "ar", "double",
        std::vector<size_t>{static_cast<size_t>(ar_1dim__)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "f_raw", "double",
        std::vector<size_t>{static_cast<size_t>(f_raw_1dim__)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> phi_param =
        std::vector<local_scalar_t__>(phi_param_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      phi_param = context__.vals_r("phi_param");
      out__.write_free_lb(1e-05, phi_param);
      std::vector<local_scalar_t__> sigma_param =
        std::vector<local_scalar_t__>(sigma_param_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      sigma_param = context__.vals_r("sigma_param");
      out__.write_free_lb(1e-05, sigma_param);
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(Q, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> gamma_flat__;
        current_statement__ = 3;
        gamma_flat__ = context__.vals_r("gamma");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(gamma, gamma_flat__[(pos__ - 1)],
            "assigning variable gamma", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(gamma);
      std::vector<local_scalar_t__> ar =
        std::vector<local_scalar_t__>(ar_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      ar = context__.vals_r("ar");
      out__.write_free_lub(-1, 1, ar);
      Eigen::Matrix<local_scalar_t__,-1,1> f_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(f_raw_1dim__,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> f_raw_flat__;
        current_statement__ = 5;
        f_raw_flat__ = context__.vals_r("f_raw");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= f_raw_1dim__; ++sym1__) {
          current_statement__ = 5;
          stan::model::assign(f_raw, f_raw_flat__[(pos__ - 1)],
            "assigning variable f_raw", stan::model::index_uni(sym1__));
          current_statement__ = 5;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(f_raw);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"phi_param", "sigma_param", "gamma",
                "ar", "f_raw"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"AD", "phi", "sigma", "f"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"y_grid_predict"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    phi_param_1dim__)},
                std::vector<size_t>{static_cast<size_t>(sigma_param_1dim__)},
                std::vector<size_t>{static_cast<size_t>(Q)},
                std::vector<size_t>{static_cast<size_t>(ar_1dim__)},
                std::vector<size_t>{static_cast<size_t>(f_raw_1dim__)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(AD_1dim__),
               static_cast<size_t>(Nsample)}, std::vector<size_t>{},
             std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(f_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(y_grid_predict_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= phi_param_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "phi_param" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= sigma_param_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_param" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= ar_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "ar" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= f_raw_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "f_raw" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= Nsample; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= AD_1dim__; ++sym2__) {
          param_names__.emplace_back(std::string() + "AD" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      param_names__.emplace_back(std::string() + "phi");
      param_names__.emplace_back(std::string() + "sigma");
      for (int sym1__ = 1; sym1__ <= f_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "f" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= y_grid_predict_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_grid_predict" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= phi_param_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "phi_param" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= sigma_param_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_param" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= ar_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "ar" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= f_raw_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "f_raw" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= Nsample; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= AD_1dim__; ++sym2__) {
          param_names__.emplace_back(std::string() + "AD" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      param_names__.emplace_back(std::string() + "phi");
      param_names__.emplace_back(std::string() + "sigma");
      for (int sym1__ = 1; sym1__ <= f_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "f" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= y_grid_predict_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_grid_predict" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"phi_param\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(phi_param_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_param\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(sigma_param_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(Q) + "},\"block\":\"parameters\"},{\"name\":\"ar\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(ar_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"f_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(f_raw_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"AD\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(AD_1dim__) + ",\"cols\":" + std::to_string(Nsample) + "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"f\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(f_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_grid_predict\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_grid_predict_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"phi_param\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(phi_param_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_param\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(sigma_param_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(Q) + "},\"block\":\"parameters\"},{\"name\":\"ar\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(ar_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"f_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(f_raw_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"AD\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(AD_1dim__) + ",\"cols\":" + std::to_string(Nsample) + "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"f\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(f_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_grid_predict\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_grid_predict_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((phi_param_1dim__ + sigma_param_1dim__) +
      Q) + ar_1dim__) + f_raw_1dim__);
    const size_t num_transformed = emit_transformed_parameters *
      (((((AD_1dim__ * Nsample) + 1) + 1) + f_1dim__));
    const size_t num_gen_quantities = emit_generated_quantities *
      (y_grid_predict_1dim__);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((phi_param_1dim__ + sigma_param_1dim__) +
      Q) + ar_1dim__) + f_raw_1dim__);
    const size_t num_transformed = emit_transformed_parameters *
      (((((AD_1dim__ * Nsample) + 1) + 1) + f_1dim__));
    const size_t num_gen_quantities = emit_generated_quantities *
      (y_grid_predict_1dim__);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_approxlgcp_nngp_namespace::model_approxlgcp_nngp;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_approxlgcp_nngp_namespace::profiles__;
}
#endif
#endif
