% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.r
\name{ds.storage.file.csv}
\alias{ds.storage.file.csv}
\title{CSV file Storage model}
\usage{
ds.storage.file.csv(location = ds.default.location(),
  extension = "csv", date.format = "\%Y-\%m-\%d",
  custom.folder = FALSE)
}
\arguments{
\item{location}{storage location, \strong{defaults to ds.default.location folder}}

\item{extension}{file extension, \strong{defaults to 'csv'}}

\item{date.format}{date format, \strong{defaults to "\%Y-\%m-\%d"}
use \strong{"\%Y-\%m-\%d \%H:\%M:\%S"} for storing intra day data}

\item{custom.folder}{custom folder flag, \strong{defaults to False}
    if flag is False \strong{default}, the data is stored at the \code{"location\src_extnsion"} folder.
if flag is True, the data is stored at the \strong{location} folder.}
}
\value{
list with storage options
}
\description{
CSV file Storage model
}
\examples{
 # change the 'yahoo' data source to use CSV files to store historical data
 register.data.source(src = 'yahoo', storage = ds.storage.file.csv())

}
