% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{tweets_data}
\alias{data_tweet}
\alias{data_tweets}
\alias{tweet_data}
\alias{tweets_data}
\title{tweets_data}
\usage{
tweets_data(users)
}
\arguments{
\item{users}{Data frame of Twitter users generated via
\code{lookup_users} or \code{search_users}.}
}
\value{
Tweets data frame.
}
\description{
Tweets data frame from users returned in a users data object.
  Typically, this involves the most recent tweet of each user, though
  in some cases the most recent tweet may not be available.
}
\examples{
\dontrun{
# search for 100 tweets containing the letter r
r <- search_tweets("r")

# print tweets data (only first 10 rows are shown)
r

# extract users data
users_data(r)
}

}
\seealso{
Other tweets: \code{\link{get_favorites}},
  \code{\link{get_timeline}},
  \code{\link{lookup_statuses}},
  \code{\link{search_tweets}}, \code{\link{stream_tweets}}
}

