% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists_users.R
\name{lists_users}
\alias{lists_users}
\title{Get all lists a specified user subscribes to, including their own.}
\usage{
lists_users(user, reverse = FALSE, token = NULL, parse = TRUE)
}
\arguments{
\item{user}{The ID of the user or screen name for whom to return results.
Helpful for disambiguating when a valid user ID is also a valid screen name.}

\item{reverse}{optional Set this to true if you would like owned lists
to be returned first. See description above for information on
how this parameter works.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find
instructions on how to create tokens and setup an environment
variable in the tokens vignette (in r, send \code{?tokens} to
console).}

\item{parse}{Logical indicating whether to convert the response object into
an R list. Defaults to TRUE.}
}
\value{
data
}
\description{
Get all lists a specified user subscribes to, including their own.
}
\examples{
\dontrun{

## get lists subsribed to by Nate Silver
lists_users("NateSilver538")

}

}
\seealso{
Other lists: \code{\link{lists_members}},
  \code{\link{lists_statuses}},
  \code{\link{lists_subscribers}}
}
