% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{tweets_data}
\alias{tweets_data}
\alias{tweet_data}
\alias{data_tweet}
\alias{data_tweets}
\title{Extracts tweets data from users data object.}
\usage{
tweets_data(users)
}
\arguments{
\item{users}{Parsed data object of users data as returned via
\code{\link{search_users}}, \code{\link{lookup_users}}, etc.}
}
\value{
Tweets data frame.
}
\description{
Extracts tweets data from users data object.
}
\examples{
\dontrun{
## get twitter user data
jack <- lookup_users("jack")

## get data on most recent tweet from user(s)
tweets_data(jack)

## search for 100 tweets containing the letter r
r <- search_tweets("r")

## print tweets data (only first 10 rows are shown)
head(r, 10)

## preview users data
head(users_data(r))
}

}
\seealso{
Other tweets: \code{\link{get_favorites}},
  \code{\link{get_mentions}}, \code{\link{get_timeline}},
  \code{\link{lists_statuses}},
  \code{\link{lookup_statuses}},
  \code{\link{search_tweets}},
  \code{\link{tweets_with_users}}

Other extractors: \code{\link{next_cursor}},
  \code{\link{users_data}}
}
