% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_mixture.R
\name{infer_mixture}
\alias{infer_mixture}
\title{Estimate mixing proportions and origin probabilities from one or several mixtures}
\usage{
infer_mixture(reference, mixture, gen_start_col, method = "MCMC",
  alle_freq_prior = list(const_scaled = 1), reps = 2000, burn_in = 100,
  pb_iter = 100, sample_int_Pi = 1)
}
\arguments{
\item{reference}{a dataframe of two-column genetic format data, proceeded by "repunit", "collection",
and "indiv" columns. Does not need "sample_type" column, and will be overwritten if provided}

\item{mixture}{a dataframe of two-column genetic format data. Must have the same structure as
\code{reference} dataframe, but "collection" and "repunit" columns are ignored.
Does not need "sample_type" column, and will be overwritten if provided}

\item{gen_start_col}{the first column of genetic data in both data frames}

\item{method}{a choice between "MCMC", "PB" methods for estimating mixture proportions}

\item{alle_freq_prior}{a one-element named list specifying the prior to be used when
generating Dirichlet parameters for genotype likelihood calculations. Valid methods include
\code{"const"}, \code{"scaled_const"}, and \code{"empirical"}. See \code{?list_diploid_params}
for method details.}

\item{reps}{the number of iterations to be performed in MCMC}

\item{burn_in}{how many reps to discard in the beginning of MCMC when doing the mean calculation.
They will still be returned in the traces if desired.}

\item{pb_iter}{how many bootstrapped data sets to do for bootstrap correction using method PB.  Default
is 100.}

\item{sample_int_Pi}{how many iterations between storing the mixing proportions trace. Default is 1.
Can't be 0. Can't be so large that fewer than 10 samples are taken from the burn in and the sweeps.}
}
\value{
Tidy data frames in a list with the following components:
mixing_proportions: the estimated mixing proportions of the different collections.
indiv_posteriors: the posterior probs of fish being from each of the collections.
mix_prop_traces: the traces of the mixing proportions.  Useful for computing credible intervals.
bootstrapped_proportions: If using method "BH" this returns the bootstrap corrected
reporting unit proportions.
}
\description{
Takes a mixture and reference dataframe of two-column genetic data, and a
desired method of estimation for the population mixture proportions (MCMC, PB)
Returns the output of the chosen estimation method
}
\details{
"MCMC" estimates mixing proportions and individual posterior
probabilities of assignment through Markov-chain Monte Carlo,
while "PB" does the same with a parametric bootstrapping correction
All methods use a uniform 1/(# collections or RUs) prior for the mixing proportions.
}
\examples{
mcmc <- infer_mixture(reference = small_chinook_ref,
                      mixture = small_chinook_mix,
                      gen_start_col = 5,
                      method = "MCMC",
                      reps  = 200)
}
