% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gprob_sim_ind}
\alias{gprob_sim_ind}
\title{Simulate genotype log-likelihoods from a population by individual}
\usage{
gprob_sim_ind(par_list, sim_colls)
}
\arguments{
\item{par_list}{genetic data converted to the param_list format by \code{tcf2param_list}}

\item{sim_colls}{a vector of indices for the collections desired for simulation;
each element of the list corresponds to an individual}
}
\value{
\code{gprob_sim} returns a matrix of the summed log-likelihoods
for all loci of a simulated population mixture; columns represent individuals,
with each row containing their log-likelihood of belonging to the collection
of the same index, given the selection of an individual's genotype from the
reference collection of interest. Selection at the locus and gene copy level
are not independent, and missing data is included in selection.
}
\description{
Takes a list of parameters from a genetic dataset, and returns a genotype log-likelihood
matrix for individuals simulated by individual from the specified collections
}
\details{
In simulation by individual, the genotype for any simulated individual is the
result of a single random draw from the genotypes of all individuals in the collection.
Gene copies and loci are therefore not independent.
}
\examples{
example(tcf2param_list)
sim_colls <- sample(ale_par_list$C, 1070, replace = TRUE)
ale_sim_gprobs_ind <- gprob_sim_ind(ale_par_list, sim_colls)
}
\keyword{internal}
