% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C5_rules.R
\name{C5_rules}
\alias{C5_rules}
\alias{update.C5_rules}
\title{General Interface for C5.0 Rule-Based Classification Models}
\usage{
C5_rules(mode = "classification", trees = NULL, min_n = NULL)

\method{update}{C5_rules}(
  object,
  parameters = NULL,
  trees = NULL,
  min_n = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "classification".}

\item{trees}{A non-negative integer (no greater than 100 for the number
of members of the ensemble.}

\item{min_n}{An integer greater than one zero and nine for the minimum number
of data points in a node that are required for the node to be split further.}

\item{object}{A \code{C5_rules} model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main} parameters to update.
If the individual arguments are used, these will supersede the values in
parameters. Also, using engine arguments in this object will result in an
error.}

\item{fresh}{A logical for whether the arguments should be modified in-place
or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\value{
An updated \code{parsnip} model specification.
}
\description{
\code{\link[=C5_rules]{C5_rules()}} is a way to generate a \emph{specification} of a model
before fitting. The main arguments for the model are:
\itemize{
\item \code{trees}: The number of sequential models included in the
ensemble (rules are derived from an initial set of boosted trees).
\item \code{min_n}: The minimum number of data points in a node that are
required for the node to be split further.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{\link[parsnip:set_engine]{parsnip::set_engine()}}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
C5.0 is a classification model that is an extension of the C4.5
model of Quinlan (1993). It has tree- and rule-based versions that also
include boosting capabilities. \code{C5_rules()} enables the version of the model
that uses a series of rules (see the examples below). To make a set of
rules, an initial C5.0 tree is created and flattened into rules. The rules
are pruned, simplified, and ordered. Rule sets are created within each
iteration of boosting.

The two main tuning parameters are the number of trees in the boosting
ensemble (\code{trees}) and the number of samples required to continue splitting
when creating a tree (\code{min_n}). There are no arguments to control the total
number of rules in the ensemble.

Note that \code{C5_rules()} does not require that categorical predictors be
converted to numeric indicator values. Note that using \code{\link[parsnip:fit]{parsnip::fit()}} will
\emph{always} create dummy variables so, if there is interest in keeping the
categorical predictors in their original format, \code{\link[parsnip:fit_xy]{parsnip::fit_xy()}} would
be a better choice. When using the \code{tune} package, using a recipe for
pre-processing enables more control over how such predictors are encoded
since recipes do not automatically create dummy variables.

Note that C5.0 has a tool for \emph{early stopping} during boosting where less
iterations of boosting are performed than the number requested. \code{C5_rules()}
turns this feature off (although it can be re-enabled using
\code{\link[C50:C5.0Control]{C50::C5.0Control()}}).
}
\examples{
C5_rules()
# Parameters can be represented by a placeholder:
C5_rules(trees = 7)

# ------------------------------------------------------------------------------

data(ad_data, package = "modeldata")

set.seed(282782)
class_rules <-
  C5_rules(trees = 1, min_n  = 10) \%>\%
  fit(Class ~ ., data = ad_data)

summary(class_rules$fit)

# ------------------------------------------------------------------------------

model <- C5_rules(trees = 10, min_n = 2)
model
update(model, trees = 1)
update(model, trees = 1, fresh = TRUE)
}
\references{
Quinlan R (1993). \emph{C4.5: Programs for Machine Learning}. Morgan
Kaufmann Publishers.
}
\seealso{
\code{\link[parsnip:fit]{parsnip::fit()}}, \code{\link[parsnip:fit_xy]{parsnip::fit_xy()}}, \code{\link[C50:C5.0]{C50::C5.0()}},
\code{\link[C50:C5.0Control]{C50::C5.0Control()}}
}
