% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Math_rv.R, R/Ops_rv.R
\name{Math.rv}
\alias{Math.rv}
\alias{Ops.rv}
\alias{!.rv}
\alias{Math.rvsim}
\alias{Ops.rvsim}
\alias{cumsum.rv}
\alias{cumprod.rv}
\alias{cummin.rv}
\alias{cummax.rv}
\title{Mathematical functions and Operators for rv Objects}
\usage{
\method{Math}{rv}(x, ...)

\method{Ops}{rv}(e1, e2 = NULL)
}
\arguments{
\item{x}{object}

\item{\dots}{further arguments passed to or from other methods}

\item{e1}{object}

\item{e2}{object}
}
\description{
Mathematical functions and operators adapted to work with random variable
(rv) objects.
}
\details{
The operator method preserves the names of the longer vector (or those of
the first if the lengths match).
}
\examples{
 
  x <- rvnorm(10)
  -x
  names(x) <- paste("x[", seq_along(x), "]", sep="")
  x + 1:10
  1:2 + x
  cumsum(x)
  cumprod(exp(x))

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
