% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvempirical.R
\name{rvempirical}
\alias{rvempirical}
\title{Generate a Random Vector from an Empirical Distribution}
\usage{
rvempirical(n, data)
}
\arguments{
\item{n}{Number of i.i.d. rv components to generate}

\item{data}{Data (constants)}
}
\description{
\code{rvempirical} generates a random vector of the same length as data from
the empirical distribution of the data.
}
\details{
\code{rvempirical}
}
\examples{

  y <- c(1.0, 1.2, 3, 1.1, 0.8, 0.9) ## Some data
  x <- rvempirical(4, data=y) 

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
