% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_data.R
\name{w_data}
\alias{w_data}
\title{Request data from a \href{https://developer.webstat.banque-france.fr/}{Webstat} dataset.}
\usage{
w_data(dataset_name, series_name = NA, startPeriod = NA, endPeriod = NA,
  firstNObs = NA, lastNObs = NA, language = "fr", format = "json",
  base_url = "https://api.webstat.banque-france.fr/webstat-", client_ID)
}
\arguments{
\item{dataset_name}{Mandatory. String (must be entered between quotes.) The datasets codes can be determined using the w_datasets() function.}

\item{series_name}{Optional. String (must be entered between quotes.) The series names can be found using the w_series(dataset) function. Wildcarding is supported by replacing one (or several) dimensions by the "*" character. At least one dimension must be specified.
Example: "M.USD.EUR.SP00.E" : US dollar exchange rate against the Euro, monthly
Example: "*.*.EUR.SP00.E" : All available exchange rates against the Euro, all available frequencies}

\item{startPeriod}{Optional. String. Start period (inclusive). ISO8601 (e.g. 2014-01) or SDMX reporting period (e.g. 2014-Q3).}

\item{endPeriod}{Optional. String. End period (inclusive). ISO8601 (e.g. 2014-01-01) or SDMX reporting period (e.g. 2014-Q3).}

\item{firstNObs}{Optional. String or Numeric. Maximum number of observations starting from the first observation}

\item{lastNObs}{Optional. String or Numeric. Maximum number of observations counting back from the most recent observation}

\item{language}{Optional. String. Defaults to "fr" (French). The only other available option is "en" (English). Determines the language of the metadata. Your Webstat "App" must be subscribed to the API in this language (or both languages) or you'll get a 501 http error.}

\item{format}{Optional. String. Defaults to "json".The only other available option is "csv". The "json" option gives a better and cleaner results (POSIX dates, etc). "csv" files are smaller and could be used to request large datasets that generate timeouts. Dataframes might then have to be cleaned manually.}

\item{base_url}{Optional. String. Defaults to "https://api.webstat.banque-france.fr/webstat-". For testing purposes.}

\item{client_ID}{Optional. String. If you do not specify it when calling the function, it will check if a global variable called "webstat_client_ID" exists and use it. If not, you will be prompted. The easiest way is to save the client ID as a string in a "webstat_client_ID" global variable.}
}
\value{
A dataframe with metadata attributes (that you can access with the w_meta() function)
}
\description{
Request data from a \href{https://developer.webstat.banque-france.fr/}{Webstat} dataset.
}
\section{Warning}{

A full dataset download will usually take a very long time and might time out and fail.
Please use the available arguments to restrict your data selection.
}

\section{Identification}{

You should declare your Webstat client ID in a global "webstat_client_ID" variable. Alternatively, you can enter your client ID as a parameter or enter it when prompted.
}

\section{Period formats}{

\itemize{
  \item Daily/Business YYYY-MM-DD
  \item Monthly YYYY-MM
  \item Quarterly YYYY-Q[1-4]
  \item Annual YYYY
}
}

\examples{
\donttest{
## Request the US Dollar monthly exchange rates in Euro
w_data(dataset_name = "EXR", series_name = "M.USD.EUR.SP00.E")

## Request the US Dollar monthly exchange rates in Euro, from May 2017 to April 2018
w_data(dataset_name = "EXR", series_name = "M.USD.EUR.SP00.E",
       startPeriod = "2017-05", endPeriod = "2018-04")

## Request the three last values of the US Dollar monthly exchange rates in Euro with
## all metadata in English
w_data(dataset_name = "EXR", series_name = "M.USD.EUR.SP00.E", lastNObs = 3, language = "en")

## Use wildcards : request all available monthly exchange rates in Euro
## (at least one dimension must be specified)
w_data(dataset_name = "EXR", series_name = "M.*.EUR.SP00.E")

## Request more than one serie
w_data("EXR", series_name = "D.DKK.EUR.SP00.A+D.GBP.EUR.SP00.A+M.USD.EUR.SP00.A+M.USD.EUR.SP00.E")

## Request all series of a dataset
w_data("CPP")

## Access metadata of the US Dollar monthly exchange rates
df = w_data(dataset_name = "EXR", series_name = "M.USD.EUR.SP00.E")
meta = w_meta(df)

\dontrun{
## Your client ID can be entered as a parameter as follows or saved
## in a global variable named "webstat_client_ID" in order to reuse it.
w_data("CPP", client_ID = "1234abcd-12ab-12ab-12ab-123456abcdef") 
}
}

}
