% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_workflow.R
\name{use_workflow}
\alias{use_workflow}
\title{Use GitHub Actions workflow}
\source{
\href{https://github.com/vubiostat/r-yaml/issues/5}{
Issue reading in "on:"/"y","n" elements}.

\href{https://github.com/vubiostat/r-yaml/issues/123}{
Issue writing "on:" as "'as':"}
}
\usage{
use_workflow(
  name = "rworkflows",
  tag = "@master",
  on = c("push", "pull_request"),
  branches = c("master", "main", "RELEASE_**"),
  runners = construct_runners(),
  run_bioccheck = FALSE,
  run_rcmdcheck = TRUE,
  as_cran = TRUE,
  run_vignettes = TRUE,
  has_testthat = TRUE,
  run_covr = TRUE,
  run_pkgdown = TRUE,
  has_runit = FALSE,
  has_latex = FALSE,
  run_docker = FALSE,
  github_token = "${{ secrets.PAT_GITHUB }}",
  docker_user = NULL,
  docker_org = docker_user,
  docker_token = "${{ secrets.DOCKER_TOKEN }}",
  cache_version = "cache-v1",
  enable_act = FALSE,
  save_dir = here::here(".github", "workflows"),
  return_path = TRUE,
  force_new = FALSE,
  preview = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{name}{Workflow name.
\itemize{
\item{"rworkflows"}{A short workflow script that calls
 the GitHub action from the GitHub Marketplace.
The action is continually updated 
so users do not need to worry about maintaining it.}
\item{"rworkflows_static"}{A longer workflow scripts that 
explicitly copies all steps from the \pkg{rworkflows} action
into a static file. Users may need to update this file themselves over time,
though this does allow for a fully customisable workflow.}
}}

\item{tag}{Which version of the \code{rworkflows} action to use. 
Can be a branch name on the
 \href{https://github.com/neurogenomics/rworkflows/branches}{
 GitHub repository} (e.g. "\@master"), 
 or a \href{https://github.com/neurogenomics/rworkflows/tags}{Release Tag} 
 (e.g. "\@v1").}

\item{on}{GitHub trigger conditions.}

\item{branches}{GitHub trigger branches.}

\item{runners}{Runner configurations for multiple Operating Systems (OS), 
including R versions, Bioc versions, and container sources.
Can use the \link[rworkflows]{construct_runners} functions to assist 
in constructing customized runners configurations.}

\item{run_bioccheck}{Run Bioconductor checks using
\href{https://doi.org/doi:10.18129/B9.bioc.BiocCheck}{
\code{BiocCheck::BiocCheck()}}. 
Must pass in order to continue workflow.}

\item{run_rcmdcheck}{Run R CMD checks using 
\href{https://r-lib.github.io/rcmdcheck/}{\code{rcmdcheck::rcmdcheck()}}. 
Must pass in order to continue workflow.}

\item{as_cran}{When running R CMD checks, 
use the '--as-cran' flag to apply CRAN standards}

\item{run_vignettes}{Build and check R package vignettes.}

\item{has_testthat}{Run unit tests and report results.}

\item{run_covr}{Run code coverage tests and publish results to codecov.}

\item{run_pkgdown}{Knit the \emph{README.Rmd} (if available), 
build documentation website, and deploy to \emph{gh-pages} branch.}

\item{has_runit}{Run R Unit tests.}

\item{has_latex}{Install a suite of LaTeX dependencies used for 
rendering Sweave (.rnw) and other documentation files.}

\item{run_docker}{Whether to build and push a Docker container to DockerHub.}

\item{github_token}{Token for the repo. 
Can be passed in using {{ secrets.PAT_GITHUB }}.}

\item{docker_user}{DockerHub username.}

\item{docker_org}{DockerHub organization name. 
Is the same as \code{docker_user} by default.}

\item{docker_token}{DockerHub token.}

\item{cache_version}{Name of the cache sudirectory to be used
when reinstalling software in GHA.}

\item{enable_act}{Whether to add extra lines to the yaml to 
enable local workflow checking with 
\href{https://github.com/nektos/act}{act}.}

\item{save_dir}{Directory to save workflow to.}

\item{return_path}{Return the path to the saved \emph{yaml} workflow file
(default: \code{TRUE}), or return the \emph{yaml} object directly.}

\item{force_new}{If the GHA workflow yaml already exists, 
overwrite with new one (default: \code{FALSE}).}

\item{preview}{Print the yaml file to the R console.}

\item{verbose}{Print messages.}
}
\value{
Path or yaml object.
}
\description{
Create workflow that calls an 
\href{https://github.com/neurogenomics/rworkflows}{rworkflows}
\href{https://github.com/features/actions}{GitHub Actions (GHA)}
}
\examples{
path <- use_workflow(save_dir = file.path(tempdir(),".github","workflows"))
}
