\name{Internal Functions}
\alias{.makesig.heavi.sine}
\alias{.makesig.bumps}
\alias{.makesig.blocks}
\alias{.makesig.doppler}
\alias{.makesig.ramp}
\alias{.makesig.cusp}
\alias{.makesig.sing}
\alias{.makesig.hi.sine}
\alias{.makesig.lo.sine}
\alias{.makesig.lin.chirp}
\alias{.makesig.two.chirp}
\alias{.makesig.quad.chirp}
\alias{.makesig.mish.mash}
\alias{.makesig.werner.sorrows}
\alias{.makesig.leopold}
\alias{.isValidSignal}
\title{Internal RWT Functions and Variables}
\description{
  Internal functions used to create artificial test signal.
}
\usage{
.makesig.heavi.sine(N, t)
.makesig.bumps(N, t)
.makesig.blocks(N, t)
.makesig.doppler(N, t)
.makesig.ramp(N, t)
.makesig.cusp(N, t)
.makesig.sing(N, t)
.makesig.hi.sine(N, t)
.makesig.lo.sine(N, t)
.makesig.lin.chirp(N, t)
.makesig.two.chirp(N, t)
.makesig.quad.chirp(N, t)
.makesig.mish.mash(N, t)
.makesig.werner.sorrows(N, t)
.makesig.leopold(N, t)
.isValidSignal(sigName)
}
\arguments{
  \item{N}{numeric scalar specifying length in samples of desired signal
    (512 by default)}
  \item{t}{numeric vector generated by \code{(1:N) / N}}
  \item{sigName}{character string specifying name of desired signal}
}
\details{
   These are not to be called directly by the user.
}
\note{
   See source for details.
}
\author{
  P. Roebuck \email{proebuck@mdanderson.org}
}
\keyword{internal}

