% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikBinom}
\alias{llikBinom}
\title{Calculate the log likelihood of the binomial function (and its derivatives)}
\usage{
llikBinom(x, size, prob, full = FALSE)
}
\arguments{
\item{x}{Number of successes}

\item{size}{Size of trial}

\item{prob}{probability of success}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the pdf value of with
\code{dProb} that has the derivatives with respect to the parameters at
the observation time-point
}
\description{
Calculate the log likelihood of the binomial function (and its derivatives)
}
\details{
In an \code{rxode2()} model, you can use \code{llikBinom()} but you have to
use all arguments.  You can also get the derivative of \code{prob} with
\code{llikBinomDprob()}
}
\examples{

llikBinom(46:54, 100, 0.5)

llikBinom(46:54, 100, 0.5, TRUE)

et <- et(46:54)
et$size <- 100
et$prob <-0.5

model <- rxode2({
  fx <- llikBinom(time, size, prob)
  dProb <- llikBinomDprob(time, size, prob)
})

rxSolve(model, et)
}
\author{
Matthew L. Fidler
}
