% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assertRxUi}
\alias{assertRxUi}
\alias{assertRxUiPrediction}
\alias{assertRxUiSingleEndpoint}
\alias{assertRxUiTransformNormal}
\alias{assertRxUiNormal}
\alias{assertRxUiMuRefOnly}
\alias{assertRxUiEstimatedResiduals}
\alias{assertRxUiPopulationOnly}
\alias{assertRxUiMixedOnly}
\alias{assertRxUiRandomOnIdOnly}
\title{Assert properties of the rxUi models}
\usage{
assertRxUi(ui, extra = "", .var.name = .vname(ui))

assertRxUiPrediction(ui, extra = "", .var.name = .vname(ui))

assertRxUiSingleEndpoint(ui, extra = "", .var.name = .vname(ui))

assertRxUiTransformNormal(ui, extra = "", .var.name = .vname(ui))

assertRxUiNormal(ui, extra = "", .var.name = .vname(ui))

assertRxUiMuRefOnly(ui, extra = "", .var.name = .vname(ui))

assertRxUiEstimatedResiduals(ui, extra = "", .var.name = .vname(ui))

assertRxUiPopulationOnly(ui, extra = "", .var.name = .vname(ui))

assertRxUiMixedOnly(ui, extra = "", .var.name = .vname(ui))

assertRxUiRandomOnIdOnly(ui, extra = "", .var.name = .vname(ui))
}
\arguments{
\item{ui}{Model to check}

\item{extra}{Extra text to append to the error message (like
"for focei")}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}
}
\value{
the rxUi model
}
\description{
Assert properties of the rxUi models
}
\details{
These functions have different types of assertions
\itemize{
\item \code{assertRxUi} -- Make sure this is a proper rxode2 model (if not throw error)
\item \code{assertRxUiSingleEndpoint} -- Make sure the rxode2 model is only
a single endpoint model (if not throw error)
\item \code{assertRxUiTransformNormal} -- Make sure that the model residual
distribution is normal or transformably normal
\item \code{assertRxUiNormal} -- Make sure that the model residual distribution is normal
\item \code{assertRxUiEstimatedResiduals} -- Make sure that the residual error
parameters are estimated (not modeled).
\item \code{assertRxUiPopulationOnly} -- Make sure the model is the population only
model (no mixed effects)
\item \code{assertRxUiMixedOnly} -- Make sure the model is a mixed effect model (not a
population effect, only)
\item \code{assertRxUiPrediction} -- Make sure the model has predictions
\item \code{assertRxUiMuRefOnly} -- Make sure that all the parameters are mu-referenced
\item \code{assertRxUiRandomOnIdOnly} -- Make sure there are only random effects at the ID level
}
}
\examples{

\donttest{
one.cmt <- function() {
 ini({
   tka <- 0.45; label("Ka")
   tcl <- log(c(0, 2.7, 100)); label("Cl")
   tv <- 3.45; label("V")
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
   add.sd <- 0.7
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
   linCmt() ~ add(add.sd)
 })
}

assertRxUi(one.cmt)
# assertRxUi(rnorm) # will fail

assertRxUiSingleEndpoint(one.cmt)
}
}
\seealso{
Other Assertions: 
\code{\link{assertCompartmentExists}()},
\code{\link{assertCompartmentName}()},
\code{\link{assertCompartmentNew}()},
\code{\link{assertVariableExists}()},
\code{\link{assertVariableNew}()},
\code{\link{testRxUnbounded}()}
}
\author{
Matthew L. Fidler
}
\concept{Assertions}
