% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relu.R
\name{ReLU}
\alias{ReLU}
\title{Rectified Linear Unit (ReLU) Activation Function}
\usage{
ReLU(x)
}
\arguments{
\item{x}{A numeric vector. All elements must be finite and
non-missing.}
}
\value{
A numeric vector where the ReLU function has been applied
to each element of \code{x}.
}
\description{
This function applies the Rectified Linear Unit (ReLU) activation function to the input numeric vector.
The ReLU function is defined as the positive part of its argument: \eqn{f(x) = max(0, x)}.
}
\examples{

ReLU(c(-1, 0, 1, 2))

# Can also be used in rxode2:
x <- rxode2({
   r=ReLU(time)
})

e <- et(c(-1, 0, 1, 2))

rxSolve(x, e)

}
\seealso{
Other Activation Functions: 
\code{\link{ELU}()},
\code{\link{GELU}()},
\code{\link{PReLU}()},
\code{\link{SELU}()},
\code{\link{Swish}()},
\code{\link{dELU}()},
\code{\link{dGELU}()},
\code{\link{dPReLU}()},
\code{\link{dReLU}()},
\code{\link{dSELU}()},
\code{\link{dSwish}()},
\code{\link{dlReLU}()},
\code{\link{dsoftplus}()},
\code{\link{lReLU}()},
\code{\link{softplus}()}
}
\author{
Matthew Fidler
}
\concept{Activation Functions}
