% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_article_comments.R
\name{get_article_comments}
\alias{get_article_comments}
\title{Get article comments}
\usage{
get_article_comments(url, id = NULL, simplify = FALSE,
  timeout = NULL)
}
\arguments{
\item{url}{character. A single character string or character vector.}

\item{id}{character. You can provide your own id for each article. If is null the function uses the md5
hash of the url to create one.}

\item{simplify}{logical. If true the function returns a data frame else it returns a nested list.}

\item{timeout}{integer. Seconds to wait between queries.}
}
\value{
A list with comments and their respective replies. If the content lies beyond the paywall
the function returns "[ZEIT PLUS CONTENT] You need a ZEIT PLUS account to access this content.".
}
\description{
Get the article comments for a single url.
}
\details{
\code{get_article_comments} is the function, which fetches and parses article comments. This function may break in the future due to layout changes on the ZEIT ONLINE website.
}
\section{Warning}{

Please use that function carefully because it uses a lot of HTTP requests. The extensive usage of this function may
result in the blocking of IP.
}

\examples{
\dontrun{
url <- paste0("https://www.zeit.de/kultur/film/2018-04/",
"tatort-frankfurt-unter-kriegern-obduktionsbericht")
get_article_comments(url = url)
}

}
\author{
Jan Dix <\email{jan.dix@uni-konstanz.de}>
}
