% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-bounds.R
\name{s2_bounds_cap}
\alias{s2_bounds_cap}
\alias{s2_bounds_rect}
\title{Compute feature-wise and aggregate bounds}
\usage{
s2_bounds_cap(x)

s2_bounds_rect(x)
}
\arguments{
\item{x}{\link[=as_s2_geography]{geography vectors}. These inputs
are passed to \code{\link[=as_s2_geography]{as_s2_geography()}}, so you can pass other objects
(e.g., character vectors of well-known text) directly.}
}
\value{
Both functions return a \code{data.frame}:
\itemize{
\item \code{\link[=s2_bounds_rect]{s2_bounds_rect()}}: Columns \code{minlng}, \code{minlat}, \code{maxlng}, \code{maxlat} (degrees)
\item \code{\link[=s2_bounds_cap]{s2_bounds_cap()}}: Columns \code{lng}, \code{lat}, \code{angle} (degrees)
}
}
\description{
\code{\link[=s2_bounds_rect]{s2_bounds_rect()}} returns a bounding latitude-longitude
rectangle that contains the region; \code{\link[=s2_bounds_cap]{s2_bounds_cap()}} returns a bounding circle
represented by a centre point (lat, lng) and an angle. The bound may not be tight
for points, polylines and geometry collections. The rectangle returned may depend on
the order of points or polylines. \code{lng_lo} values larger than \code{lng_hi} indicate
regions that span the antimeridian, see the Fiji example.
}
\examples{
s2_bounds_cap(s2_data_countries("Antarctica"))
s2_bounds_cap(s2_data_countries("Netherlands"))
s2_bounds_cap(s2_data_countries("Fiji"))

s2_bounds_rect(s2_data_countries("Antarctica"))
s2_bounds_rect(s2_data_countries("Netherlands"))
s2_bounds_rect(s2_data_countries("Fiji"))

}
