% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeanDims.R
\name{MeanDims}
\alias{MeanDims}
\title{Average an array along multiple dimensions}
\usage{
MeanDims(data, dims, na.rm = FALSE)
}
\arguments{
\item{data}{An array to be averaged.}

\item{dims}{A vector of numeric or charactor string, indicating along which 
dimensions to average.}

\item{na.rm}{A logical value indicating whether to ignore NA values (TRUE) or 
not (FALSE).}
}
\value{
An array with the same dimension as parameter 'data' except the 'dims' 
 dimensions. 
 removed.
}
\description{
This function returns the mean of an array along a set of dimensions and 
preserves the dimension names if it has.
}
\examples{
a <- array(rnorm(24), dim = c(2, 3, 4))
MeanDims(a, 2)
MeanDims(a, c(2, 3))
}
