% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Persistence.R
\name{Persistence}
\alias{Persistence}
\title{Compute persistence}
\usage{
Persistence(
  data,
  dates,
  time_dim = "time",
  start,
  end,
  ft_start,
  ft_end = ft_start,
  max_ft = 10,
  nmemb = 1,
  na.action = 10,
  ncores = NULL
)
}
\arguments{
\item{data}{A numeric array corresponding to the observational data
including the time dimension along which the autoregression is computed.
The data should start at least 40 time steps (years or days) before 
'start'.}

\item{dates}{A sequence of 4-digit integers (YYYY) or string (YYYY-MM-DD) 
in class 'Date' indicating the dates available in the observations.}

\item{time_dim}{A character string indicating the dimension along which to 
compute the autoregression. The default value is 'time'.}

\item{start}{A 4-digit integer (YYYY) or a string (YYYY-MM-DD) in class 'Date'
indicating the first start date of the persistence forecast. It must be 
between 1850 and 2020.}

\item{end}{A 4-digit integer (YYYY) or a string (YYYY-MM-DD) in class 'Date'
indicating the last start date of the persistence forecast. It must be
between 1850 and 2020.}

\item{ft_start}{An integer indicating the forecast time for which the 
persistence forecast should be calculated, or the first forecast time of
the average forecast times for which persistence should be calculated.}

\item{ft_end}{An (optional) integer indicating the last forecast time of the
average forecast times for which persistence should be calculated in the
case of a multi-timestep average persistence. The default value is 
'ft_start'.}

\item{max_ft}{An integer indicating the maximum forecast time possible for 
'data'. For example, for decadal prediction 'max_ft' would correspond to 10
(years). The default value is 10.}

\item{nmemb}{An integer indicating the number of ensemble members to generate 
for the persistence forecast. The default value is 1.}

\item{na.action}{A function or an integer. A function (e.g., na.omit, 
na.exclude, na.fail, na.pass) indicates what should happen when the data 
contain NAs. A numeric indicates the maximum number of NA position allowed 
to compute regression. The default value is 10.}

\item{ncores}{An integer indicating the number of cores to use for parallel
computation. The default value is NULL.}
}
\value{
A list containing:
\item{$persistence}{
 A numeric array with dimensions 'memb', time (start dates), latitudes and longitudes
 containing the persistence forecast.   
}
\item{$persistence.mean}{
 A numeric array with same dimensions as 'persistence', except the 'memb' dimension
 which is of length 1, containing the ensemble mean persistence forecast.
}
\item{$persistence.predint}{
 A numeric array with same dimensions as 'persistence', except the 'memb' dimension
 which is of length 1, containing the prediction interval of the persistence forecast.
}
\item{$AR.slope}{
 A numeric array with same dimensions as 'persistence', except the 'memb' dimension
 which is of length 1, containing the slope coefficient of the autoregression.
}
\item{$AR.intercept}{
 A numeric array with same dimensions as 'persistence', except the 'memb' dimension
 which is of length 1, containing the intercept coefficient of the autoregression.
}
\item{$AR.lowCI}{
 A numeric array with same dimensions as 'persistence', except the 'memb' dimension
 which is of length 1, containing the lower value of the confidence interval of the
 autoregression.
}
\item{$AR.highCI}{
 A numeric array with same dimensions as 'persistence', except the 'memb' dimension
 which is of length 1, containing the upper value of the confidence interval of the
 autoregression.
}
}
\description{
Compute a persistence forecast based on a lagged autoregression of 
observational data along the time dimension, with a measure of forecast 
uncertainty (prediction interval) based on Coelho et al., 2004.\cr\cr
}
\examples{
# Case 1: year
# Building an example dataset with yearly start dates from 1920 to 2009
set.seed(1)
obs1 <- rnorm(1 * 70 * 2 * 2)
dim(obs1) <- c(member = 1, time = 70, lat = 2, lon = 2)
dates <- seq(1920, 1989, 1)
res <- Persistence(obs1, dates = dates, start = 1961, end = 1980, ft_start = 1,
                  nmemb = 2)
# Case 2: day
dates <- seq(as.Date(ISOdate(1990, 1, 1)), as.Date(ISOdate(1990, 4, 1)) ,1)
start <- as.Date(ISOdate(1990, 2, 15))
end <-  as.Date(ISOdate(1990, 4, 1))
set.seed(1)
data <- rnorm(1 * length(dates))
dim(data) <- c(member = 1, time = length(dates))
res <- Persistence(data, dates = dates, start = start, end = end, ft_start = 1)

}
