% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3FileResourceGetter.R
\docType{class}
\name{S3FileResourceGetter}
\alias{S3FileResourceGetter}
\title{AWS S3 file resource getter}
\format{
A R6 object of class S3FileResourceGetter
}
\description{
AWS S3 file resource getter

AWS S3 file resource getter
}
\details{
Access a file that is in the Amazon Web Services S3 file store or in a HTTP S3 compatible file store such as Minio. 
For AWS S3 the host name is the bucket name. For Minio, the url will include http or https base protocol. 
Credentials may apply.
}
\section{Super class}{
\code{\link[resourcer:FileResourceGetter]{resourcer::FileResourceGetter}} -> \code{S3FileResourceGetter}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{S3FileResourceGetter$new()}}
\item \href{#method-isFor}{\code{S3FileResourceGetter$isFor()}}
\item \href{#method-downloadFile}{\code{S3FileResourceGetter$downloadFile()}}
\item \href{#method-clone}{\code{S3FileResourceGetter$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="FileResourceGetter" data-id="extractFileName">}\href{../../resourcer/html/FileResourceGetter.html#method-extractFileName}{\code{resourcer::FileResourceGetter$extractFileName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="FileResourceGetter" data-id="makeDownloadDir">}\href{../../resourcer/html/FileResourceGetter.html#method-makeDownloadDir}{\code{resourcer::FileResourceGetter$makeDownloadDir()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new S3FileResourceGetter instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileResourceGetter$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A S3FileResourceGetter object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isFor"></a>}}
\if{latex}{\out{\hypertarget{method-isFor}{}}}
\subsection{Method \code{isFor()}}{
Check that the provided resource has a URL that locates a file accessible through "s3" protocol or 
"s3+http" or "s3+https" protocol (i.e. using Minio implementation of the AWS S3 file store API over HTTP).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileResourceGetter$isFor(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{The resource object to validate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-downloadFile"></a>}}
\if{latex}{\out{\hypertarget{method-downloadFile}{}}}
\subsection{Method \code{downloadFile()}}{
Download the file from the remote address in a temporary location. Applies authentication if credentials are provided in the resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileResourceGetter$downloadFile(resource, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{A valid resource object.}

\item{\code{...}}{Unused additional parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The "resource.file" object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileResourceGetter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
