% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sSDR.R
\name{disvm}
\alias{disvm}
\title{Subspace distance}
\usage{
disvm(v1, v2)
}
\arguments{
\item{v1}{A matrix, each column consists of a p-dimensional vector.}

\item{v2}{A matrix, each column consists of a p-dimensional vector.}
}
\value{
A scaler represents the distance between the two spaces spanned by
v1 and v2 respectively.
}
\description{
Subspace distance
}
\details{
This function computes the distances between two spaces using the formulation
in Li, Zha, Chiaromonte (2005), which is the Frobenius norm of the difference
between the two orthogonal projection matrices defined by v1 and v2.
}
\examples{
v1 <- c(1, 0, 0)
v2 <- c(0, 1, 0)
disvm(v1, v1)
disvm(v1, v2)
}
\references{
Li, B., Zha, H., and Chiaromonte, F. (2005). Contour regression:
a general approach to dimension reduction. Annals of Statistics,
33(4):1580-1616.
}

