% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapcurves.R
\name{mapcurves}
\alias{mapcurves}
\title{Mapcurves}
\usage{
mapcurves(x, y, z = NULL)
}
\arguments{
\item{x}{A numeric vector, representing a categorical values.}

\item{y}{A numeric vector, representing a categorical values.}

\item{z}{A numeric matrix. The goodness of fit (GOF) value for each pair of
classes in \code{x} and \code{y}. By default this argument is set to \code{NULL},
and the value of \code{z} is calculated based on \code{x} and \code{y}.}
}
\value{
A list with two elements:
\itemize{
\item "ref_map" - the map to be used as reference ("x" or "y")
\item "gof" - the Mapcurves's goodness of fit value
}
}
\description{
Mapcurves: a quantitative method for comparing categorical maps.
}
\examples{
set.seed(2018-03-21)
A = floor(matrix(runif(100, 0, 9), 10))
B = floor(matrix(runif(100, 0, 9), 10))
mapcurves(A, B)

}
\references{
Hargrove, William W., Forrest M. Hoffman, and Paul F. Hessburg.
"Mapcurves: a quantitative method for comparing categorical maps."
Journal of Geographical Systems 8.2 (2006): 187.
}
