% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saeFH.uprop.R
\name{saeFH.uprop}
\alias{saeFH.uprop}
\title{EBLUPs based on a Univariate Fay Herriot model with Additive Logistic Transformation}
\usage{
saeFH.uprop(formula, vardir, MAXITER = 100, PRECISION = 1e-04, L = 1000, data)
}
\arguments{
\item{formula}{an object of class \code{\link[stats]{formula}} that describe the fitted model.}

\item{vardir}{vector containing the sampling variances of direct estimators for each domain. The values must be sorted as the variables in \code{formula}.}

\item{MAXITER}{maximum number of iterations allowed in the Fisher-scoring algorithm, Default: \code{100}.}

\item{PRECISION}{convergence tolerance limit for the Fisher-scoring algorithm, Default: \code{1e-4}.}

\item{L}{number of Monte Carlo iterations in calculating Empirical Best Predictor (EBP), Default: \code{1000}.}

\item{data}{optional data frame containing the variables named in \code{formula} and \code{vardir}.}
}
\value{
The function returns a list with the following objects:
   \item{est}{a data frame containing values of the estimators for each domains.}
     \itemize{
       \item \code{PC} : transformed EBLUP estimators using inverse alr.
       \item \code{EBP} : Empirical Best Predictor using Monte Carlo.
     }
   \item{fit}{a list containing the following objects (model is fitted using REML):}
     \itemize{
       \item \code{convergence} : a logical value equal to \code{TRUE} if Fisher-scoring algorithm converges in less than \code{MAXITER} iterations.
       \item \code{iterations} : number of iterations performed by the Fisher-scoring algorithm.
       \item \code{estcoef} : a data frame that contains the estimated model coefficients, standard errors, t-statistics, and p-values of each coefficient.
       \item \code{refvar} : estimated random effects variance.
     }
   \item{components}{a data frame containing the following columns:}
     \itemize{
       \item \code{random.effects} : estimated random effect values of the fitted model.
       \item \code{residuals} : residuals of the fitted model.
     }
}
\description{
This function gives the transformed EBLUP and Empirical Best Predictor (EBP) based on a univariate Fay-Herriot model.
}
\examples{
## Load dataset
data(datasaeu)

## If data is defined
Fo = y ~ x1 + x2
vardir = "vardir"
model.data <- saeFH.uprop(Fo, vardir, data = datasaeu)

## If data is undefined
Fo = datasaeu$y ~ datasaeu$x1 + datasaeu$x2
vardir = datasaeu$vardir
model <- saeFH.uprop(Fo, vardir)

## See the estimators
model$est

}
