% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalTF.R
\name{NormalTF}
\alias{NormalTF}
\title{Small Area Estimation Using Hierarchical Bayesian Method under Twofold Subarea Level Model with Normal distribution}
\usage{
NormalTF(
  formula,
  vardir,
  area,
  weight,
  iter.update = 3,
  iter.mcmc = 2000,
  thin = 1,
  burn.in = 1000,
  data,
  coef,
  var.coef
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{vardir}{Sampling variances of direct estimations on each subarea}

\item{area}{Index that describes the code relating to area in each subarea.This should be defined for aggregation to get area estimator. Index start from 1 until m}

\item{weight}{Vector contain proportion units or proportion of population on each subarea. \eqn{w_{ij}}}

\item{iter.update}{Number of updates perform in Gibbs Sampling with default \code{3}}

\item{iter.mcmc}{Number of total iteration per chain perform in Gibbs Sampling with default \code{2000}}

\item{thin}{Thinning rate perform in Gibbs Sampling and it must be a positive integer with default \code{1}}

\item{burn.in}{Number of burn in period in Gibbs Sampling with default \code{1000}}

\item{data}{The data frame}

\item{coef}{Initial value for mean on coefficient's prior distribution or \eqn{\beta}'s prior distribution}

\item{var.coef}{Initial value for varians on coefficient's prior distribution or \eqn{\beta}'s prior distribution}
}
\value{
This function returns a list with following objects:
\describe{
  \item{Est_sub}{A dataframe that contains the values, standar deviation, and quantile of Subarea mean Estimates using Twofold Subarea level model under Hierarchical Bayes method}
  \item{Est_area}{A dataframe that contains the values, standar deviation, and quantile of Area mean Estimates using Twofold Subarea level model under Hierarchical Bayes method}
  \item{refVar}{A dataframe that contains estimated subarea and area random effect variance \eqn{(\sigma_{u}^{2}} and \eqn{\sigma_{v}^{2})}}
  \item{coefficient}{A dataframe that contains the estimated model coefficient \eqn{\beta}}
  \item{plot}{Trace, Density, Autocorrelation Function Plot of coefficient}
}
}
\description{
\itemize{
 \item {This function is implemented to variable of interest \eqn{y} that assumed to be a Normal Distribution. The range of data is \eqn{-\infty <y<\infty}}
 \item {This function gives estimation of subarea and area means simultaneously under Twofold Subarea Level Small Area Estimation Model Using Hierarchical Bayesian Method with Normal distribution}
}
}
\examples{
##load dataset for data without any nonsampled subarea
data(dataTwofold)

#formula of fitted model
formula=y~x1+x2

#model fitting
mod=NormalTF(formula,vardir="vardir",area="codearea",weight="w",data=dataTwofold)

#estimate
mod$Est_sub #Subarea mean estimate
mod$Est_area #area mean estimate
mod$coefficient #coefficient estimate
mod$refVar #random effect subarea and area estimates

##for dataset with nonsampled subarea use dataTwofoldNS
}
