\name{saemix.plot.select}
\alias{saemix.plot.select}
\title{ Plots of the results obtained by SAEM}
\description{ Several plots (selectable by the type argument) are currently available: convergence plot, individual plots, predictions versus observations, distribution plots, residual plots, VPC.
}
\usage{
saemix.plot.select(saemixObject, data = FALSE, convergence = FALSE,
  likelihood = FALSE, individual.fit = FALSE, population.fit = FALSE, 
  both.fit = FALSE, observations.vs.predictions = FALSE,
  residuals.scatter = FALSE, residuals.distribution = FALSE,
  random.effects = FALSE, correlations = FALSE, 
  parameters.vs.covariates = FALSE, randeff.vs.covariates = FALSE, 
  marginal.distribution = FALSE, vpc = FALSE, npde = FALSE, ...)
}
\arguments{   
  \item{saemixObject}{ an object returned by the \code{\link{saemix}} function}
  \item{data}{ if TRUE, produce a plot of the data. Defaults to FALSE}
  \item{convergence}{ if TRUE, produce a convergence plot. Defaults to FALSE}
  \item{likelihood}{ if TRUE, produce a plot of the estimation of the LL by importance sampling. Defaults to FALSE}
  \item{individual.fit}{if TRUE, produce individual fits with individual estimates. Defaults to FALSE}
  \item{population.fit}{ if TRUE, produce individual fits with population estimates. Defaults to FALSE}
  \item{both.fit}{ if TRUE, produce individual fits with both individual and population estimates. Defaults to FALSE}
  \item{observations.vs.predictions}{ if TRUE, produce a plot of observations versus predictions. Defaults to FALSE}
  \item{residuals.scatter}{ if TRUE, produce scatterplots of residuals versus predictor and predictions. Defaults to FALSE}
  \item{residuals.distribution}{ if TRUE, produce plots of the distribution of residuals. Defaults to FALSE}
  \item{random.effects}{ if TRUE, produce boxplots of the random effects. Defaults to FALSE}
  \item{correlations}{ if TRUE, produce a matrix plot showing the correlation between random effects. Defaults to FALSE}
  \item{parameters.vs.covariates}{ if TRUE, produce plots of the relationships between parameters and covariates, using the Empirical Bayes Estimates of individual parameters. Defaults to FALSE}
  \item{randeff.vs.covariates}{ if TRUE, produce plots of the relationships between random effects and covariates, using the Empirical Bayes Estimates of individual random effects. Defaults to FALSE}
  \item{marginal.distribution}{ if TRUE, produce plots of the marginal distribution of the random effects. Defaults to FALSE}
  \item{vpc}{ if TRUE, produce Visual Predictive Check plots. Defaults to FALSE}
  \item{npde}{ if TRUE, produce plots of the npde. Defaults to FALSE}
  \item{\dots}{ optional arguments passed to the plots}
}
\details{This function plots different graphs related to the algorithm (convergence plots, likelihood estimation) as well as diagnostic graphs. A description is provided in the PDF documentation.
\describe{
  \item{data}{A spaghetti plot of the data, displaying the observed data y as a function of the regression variable (eg time for a PK application)}
  \item{convergence}{For each parameter in the model, this plot shows the evolution of the parameter estimate versus the iteration number}
  \item{likelihood}{Estimation of the likelihood estimated by importance sampling, as a function of the number of MCMC samples}
  \item{individual.fit}{Individual fits, using the individual parameters with the individual covariates}
  \item{population.fit}{Individual fits, using the population parameters with the individual covariates}
  \item{both.fit}{Individual fits, using the population parameters with the individual covariates and the individual parameters with the individual covariates}
  \item{observations.vs.predictions}{Plot of the predictions computed with the population parameters versus the observations (left), and plot of the predictions computed with the individual parameters versus the observations (right)}
  \item{residuals.scatter}{Scatterplot of standardised residuals versus the X predictor and versus predictions. These plots are shown for individual and population residuals, as well as for npde when they are available}
  \item{residuals.distribution}{Distribution of standardised residuals, using histograms and QQ-plot. These plots are shown for individual and population residuals, as well as for npde when they are available}
  \item{random.effects}{Boxplot of the random effects}
  \item{correlations}{Correlation between the random effects, with a smoothing spline}
  \item{parameters.versus.covariates}{Plots of the estimate of the individual parameters versus the covariates, using scatterplot for continuous covariates, boxplot for categorical covariates}
  \item{randeff.versus.covariates}{Plots of the estimate of the individual random effects versus the covariates, using scatterplot for continuous covariates, boxplot for categorical covariates}
  \item{marginal.distribution}{Distribution of each parameter in the model (conditional on covariates when some are included in the model)}
  \item{npde}{Plot of npde as in package npde}
  \item{vpc}{Visual Predictive Check}
}
}
\value{None}
\references{ Kuhn, E., and Lavielle, M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis 49, 4 (2005), 1020-1038.

Monolix32_UsersGuide.pdf (\url{http://software.monolix.org/sdoms/software/})
}
\author{ Emmanuelle Comets <emmanuelle.comets@inserm.fr>, Audrey Lavenu, Marc Lavielle.
}

\seealso{\code{\link{SaemixObject}},\code{\link{saemix}}, \code{\link{default.saemix.plots}},
\code{\link{saemix.plot.setoptions}}, \code{\link{saemix.plot.data}}, \code{\link{saemix.plot.convergence}}, \code{\link{saemix.plot.llis}}, \code{\link{saemix.plot.randeff}}, \code{\link{saemix.plot.obsvspred}}, \code{\link{saemix.plot.fits}}, \code{\link{saemix.plot.parcov}}, \code{\link{saemix.plot.randeffcov}}, \code{\link{saemix.plot.distpsi}}, \code{\link{saemix.plot.scatterresiduals}}, \code{\link{saemix.plot.distribresiduals}}, \code{\link{saemix.plot.vpc}}}
\examples{
data(theo.saemix)

saemix.data<-saemixData(name.data=theo.saemix,header=TRUE,sep=" ",na=NA, 
  name.group=c("Id"),name.predictors=c("Dose","Time"),
  name.response=c("Concentration"),name.covariates=c("Weight","Sex"),
  units=list(x="hr",y="mg/L",covariates=c("kg","-")), name.X="Time")

model1cpt<-function(psi,id,xidep) { 
	  dose<-xidep[,1]
	  tim<-xidep[,2]  
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}

saemix.model<-saemixModel(model=model1cpt,
  description="One-compartment model with first-order absorption", 
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")

saemix.options<-list(seed=632545,save=FALSE,save.graphs=FALSE)

saemix.fit<-saemix(saemix.model,saemix.data,saemix.options)

saemix.plot.select(saemix.fit,data=TRUE,main="Spaghetti plot of data")

# Putting several graphs on the same plot
par(mfrow=c(2,2))
saemix.plot.select(saemix.fit,data=TRUE,vpc=TRUE,
  observations.vs.predictions=TRUE, new=FALSE)
}
\keyword{plot}
