% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/SaemixData.R,
%   R/SaemixModel.R, R/SaemixRes.R, R/SaemixObject.R
\docType{methods}
\name{initialize-methods}
\alias{initialize-methods}
\alias{initialize,SaemixData-method}
\alias{initialize,SaemixRepData-method}
\alias{initialize,SaemixSimData-method}
\alias{initialize,SaemixModel-method}
\alias{initialize,SaemixRes-method}
\alias{initialize,SaemixObject-method}
\title{Methods for Function initialize}
\usage{
\S4method{initialize}{SaemixData}(
  .Object,
  name.data,
  header,
  sep,
  na,
  name.group,
  name.predictors,
  name.response,
  name.covariates,
  name.X,
  units,
  name.mdv,
  name.cens,
  name.occ,
  name.ytype,
  verbose
)

\S4method{initialize}{SaemixRepData}(.Object, data = NULL, nb.chains = 1)

\S4method{initialize}{SaemixSimData}(.Object, data = NULL, datasim = NULL)

\S4method{initialize}{SaemixModel}(
  .Object,
  model,
  description,
  psi0,
  name.response,
  name.sigma,
  transform.par,
  fixed.estim,
  error.model,
  covariate.model,
  covariance.model,
  omega.init,
  error.init,
  name.modpar,
  verbose = TRUE
)

\S4method{initialize}{SaemixRes}(
  .Object,
  name.fixed,
  name.random,
  name.sigma,
  fixed.effects,
  fixed.psi,
  betaC,
  betas,
  omega,
  respar,
  cond.mean.phi,
  cond.var.phi,
  mean.phi,
  phi,
  phi.samp,
  parpop,
  allpar,
  MCOV
)

\S4method{initialize}{SaemixObject}(.Object, data, model, options = list())
}
\arguments{
\item{.Object}{a SaemixObject, SaemixRes, SaemixData or SaemixModel object to initialise}

\item{name.data}{name of the dataset (can be a character string giving the name of a file on disk or of a dataset in the R session, or the name of a dataset}

\item{header}{whether the dataset/file contains a header. Defaults to TRUE}

\item{sep}{the field separator character. Defaults to any number of blank spaces ("")}

\item{na}{a character vector of the strings which are to be interpreted as NA values. Defaults to c(NA)}

\item{name.group}{name (or number) of the column containing the subject id}

\item{name.predictors}{name (or number) of the column(s) containing the predictors (the algorithm requires at least one predictor x)}

\item{name.response}{name (or number) of the column containing the response variable y modelled by predictor(s) x}

\item{name.covariates}{name (or number) of the column(s) containing the covariates, if present (otherwise missing)}

\item{name.X}{name of the column containing the regression variable to be used on the X axis in the plots (defaults to the first predictor)}

\item{units}{list with up to three elements, x, y and optionally covariates, containing the units for the X and Y variables respectively, as well as the units for the different covariates (defaults to empty)}

\item{name.mdv}{name of the column containing the indicator for missing variable}

\item{name.cens}{name of the column containing the indicator for censoring}

\item{name.occ}{name of the column containing the occasion}

\item{name.ytype}{name of the column containing the index of the response}

\item{verbose}{a boolean indicating whether messages should be printed out during the creation of the object (defaults to TRUE)}

\item{data}{an SaemixData object}

\item{nb.chains}{number of chains used in the algorithm}

\item{datasim}{dataframe containing the simulated data}

\item{model}{name of the function used to compute the structural model. The
function should return a vector of predicted values given a matrix of
individual parameters, a vector of indices specifying which records belong
to a given individual, and a matrix of dependent variables (see example
below).}

\item{description}{a character string, giving a brief description of the
model or the analysis}

\item{psi0}{a matrix with a number of columns equal to the number of
parameters in the model, and one (when no covariates are available) or two
(when covariates enter the model) giving the initial estimates for the fixed
effects. The column names of the matrix should be the names of the
parameters in the model, and will be used in the plots and the summaries.
When only the estimates of the mean parameters are given, psi0 may be a
named vector.}

\item{name.sigma}{a vector of character string giving the names of the residual error parameters (defaults to "a" and "b")}

\item{transform.par}{the distribution for each parameter (0=normal,
1=log-normal, 2=probit, 3=logit). Defaults to a vector of 1s (all parameters
have a log-normal distribution)}

\item{fixed.estim}{whether parameters should be estimated (1) or fixed to
their initial estimate (0). Defaults to a vector of 1s}

\item{error.model}{type of residual error model (valid types are constant,
proportional, combined and exponential). Defaults to constant}

\item{covariate.model}{a matrix giving the covariate model. Defaults to no
covariate in the model}

\item{covariance.model}{a square matrix of size equal to the number of parameters in the model, 
giving the variance-covariance matrix of the model: 1s correspond to estimated variances (in the diagonal) 
or covariances (off-diagonal elements). Defaults to the identity matrix}

\item{omega.init}{a square matrix of size equal to the number of parameters
in the model, giving the initial estimate for the variance-covariance matrix
of the model. Defaults to the identity matrix}

\item{error.init}{a vector of size 2 giving the initial value of a and b in
the error model. Defaults to 1 for each estimated parameter in the error model}

\item{name.modpar}{names of the model parameters, if they are not given as
the column names (or names) of psi0}

\item{name.fixed}{a character string  giving the name of the fixed parameters}

\item{name.random}{a character string  giving the name of the random parameters}

\item{fixed.effects}{vector with the estimates of h(mu) and betas in estimation order}

\item{fixed.psi}{vector with the estimates of h(mu)}

\item{betaC}{vector with the estimates of betas (estimated fixed effects for covariates)}

\item{betas}{vector with the estimates of mu}

\item{omega}{estimated variance-covariance matrix}

\item{respar}{vector with the estimates of the parameters of the residual error}

\item{cond.mean.phi}{matrix of size (number of subjects) x (nb of parameters) containing the conditional mean estimates of the, defined as the mean of the conditional distribution}

\item{cond.var.phi}{matrix of the variances on cond.mean.phi, defined as the variance of the conditional distribution}

\item{mean.phi}{matrix of size (number of subjects) x (nb of parameters) giving for each subject the estimates of the population parameters including covariate effects}

\item{phi}{matrix of size (number of subjects) x (nb of parameters) giving for each subject}

\item{phi.samp}{samples from the individual conditional distributions of the phi}

\item{parpop}{population parameters at each iteration}

\item{allpar}{all parameters (including covariate effects) at each iteration}

\item{MCOV}{design matrix C}

\item{options}{a list of options passed to the algorithm}
}
\description{
Constructor functions for Classes in the saemix package
}
\section{Methods}{
 \describe{

\item{list("signature(.Object = \"SaemixData\")")}{ create a SaemixData
object. Please use the \code{\link{saemixData}} function.}

\item{list("signature(.Object = \"SaemixModel\")")}{ create a SaemixModel
object Please use the \code{\link{saemixModel}} function.}

\item{list("signature(.Object = \"SaemixObject\")")}{ create a SaemixObject
object. This object is obtained after a successful call to
\code{\link{saemix}}}

\item{list("signature(.Object = \"SaemixRepData\")")}{ create a
SaemixRepData object}

\item{list("signature(.Object = \"SaemixRes\")")}{ create a SaemixRes
object}

\item{list("signature(.Object = \"SaemixSimData\")")}{ create a
SaemixSimData object} }
}

\keyword{methods}
