% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{retrieve_object}
\alias{retrieve_object}
\alias{load2}
\title{Retrieve a R object from a connection}
\usage{
retrieve_object(conn, ascii = FALSE, key = "pass", method = "symmetric")
}
\arguments{
\item{conn}{A connection or a file to be decrypted.}

\item{ascii}{TRUE, if conn is a text connection or a ascii file. FALSE, if
conn is a raw connection or a binary file}

\item{key}{A string without embbeded NULL. Default is 'pass'.}

\item{method}{Currently, a stub. It should be 'symmetric'(default).}
}
\value{
An invisible TRUE
}
\description{
\code{save_object} encrypts a R object to raw or text connection
  or a file. \code{retrieve_object} decrypts a raw or a text connection or a
  file (encrypted by \code{save_object}). Note that \code{retrieve_object}
  returns the object.
}
\examples{
all(
  save_object(iris, conn = "iris_safer.bin")
  , identical(retrieve_object(conn = "iris_safer.bin"), iris)
  , unlink("iris_safer.bin") == 0
)

all(
  save_object(iris, conn = "iris_safer_2.txt", ascii = TRUE)
  , identical(retrieve_object(conn = "iris_safer_2.txt", ascii = TRUE), iris)
  , unlink("iris_safer_2.txt") == 0
)

}
