% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{plotSafeTDesignSampleSizeProfile}
\alias{plotSafeTDesignSampleSizeProfile}
\title{Plots the Sample Sizes Necessary for a Tolerable Alpha and Beta as a Function of deltaMin}
\usage{
plotSafeTDesignSampleSizeProfile(
  alpha = 0.05,
  beta = 0.2,
  nMax = 100,
  lowDeltaMin = 0.1,
  highDeltaMin = 1,
  stepDeltaMin = 0.1,
  testType = c("oneSample", "paired", "twoSample"),
  alternative = c("two.sided", "greater", "less"),
  ratio = 1,
  nSim = 1000L,
  nBoot = 1000L,
  seed = NULL,
  pb = TRUE,
  freqPlot = FALSE,
  ...
)
}
\arguments{
\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent of n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both
the sample sizes and deltaS, which defines the test. Note that 1-beta defines the power.}

\item{nMax}{numeric, the maximum number of samples one has budget for to collect data.}

\item{lowDeltaMin}{numeric, lowest value for deltaMin of interest}

\item{highDeltaMin}{numeric, largest value for deltaMin of interest}

\item{stepDeltaMin}{numeric, step size between lowDeltaMin and highDeltaMin}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "two.sided" (default),
"greater" or "less".}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 over condition 1. If testType
is not equal to "twoSample", or if nPlan is of length(1) then ratio=1.}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of samples paths
for the safe z test under continuous monitoring.}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of
approximation of the power, the number of samples for the safe z test under continuous monitoring,
or for the computation of the logarithm of the implied target.}

\item{seed}{integer, seed number.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}

\item{freqPlot}{logical, if \code{TRUE} plot frequentist sample size profiles.}

\item{...}{further arguments to be passed to or from methods, but mainly to perform do.calls.}
}
\value{
Returns a list that contains the planned sample size needed for the frequentist and safe tests as a function
of the minimal clinically relevant effect sizes. The returned list contains at least the following components:

\describe{
  \item{alpha}{the tolerable type I error provided by the user.}
  \item{beta}{the tolerable type II error provided by the user.}
  \item{maxN}{the largest number of samples provided by the user.}
  \item{deltaDomain}{vector of the domain of deltaMin.}
  \item{allN1PlanFreq}{vector of the planned sample sizes needed for the frequentist test corresponding to
  alpha and beta.}
  \item{allN1PlanSafe}{vector of the planned sample sizes needed for the safe test corresponding to alpha
  and beta.}
  \item{allDeltaS}{vector of safe test defining deltaS.}
}
}
\description{
For given tolerable alpha and beta, (1) the planned sample sizes to using a safe test, (2) the
frequentist test, and (3) the average sample size necessary due to optional stopping are plotted
as a  function of the minimal clinically relevant standardised effect size deltaMin.
}
\examples{
plotSafeTDesignSampleSizeProfile(nSim=1e2L)
}
