% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSettings.R
\name{generateSettings}
\alias{generateSettings}
\title{Generate a settings object based on a data standard}
\usage{
generateSettings(standard = "None", chart = "eDish", partial = FALSE,
  partial_cols = NULL)
}
\arguments{
\item{standard}{The data standard for which to create settings. Valid options are "SDTM", "AdAM" or "None". Default: \code{"SDTM"}}

\item{chart}{The chart for which standards should be generated ("eDish" only for now) . Default: \code{"eDish"}.}

\item{partial}{Boolean for whether or not the standard is a partial standard. Default: \code{"NULL"}.}

\item{partial_cols}{Optional character vector of the matched cols if partial is TRUE. It will not be used if partial is FALSE Default: \code{"NULL"}.}
}
\value{
A list containing the appropriate settings for the selected chart
}
\description{
This function returns a settings object for the eDish chart based on the specified data standard.
}
\details{
The function is designed to work with the SDTM and AdAM CDISC(<https://www.cdisc.org/>) standards for clinical trial data. Currently, eDish is the only chart supported.
}
\examples{

generateSettings(standard="SDTM") 
generateSettings(standard="SdTm") #also ok
generateSettings(standard="SDTM", partial=TRUE, partial_cols = c("USUBJID","TEST","STRESN"))
generateSettings(standard="AdAM")

generateSettings(standard="a different standard") 
#returns shell settings list with no data mapping

\dontrun{
generateSettings(standard="adam",chart="AEExplorer") #Throws error. Only eDish supported so far. 
}

}
