% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Q_theta}
\alias{Q_theta}
\title{Objective function}
\usage{
Q_theta(R, nobs, lambda, alpha, we, wj, wje, betaE, theta_list, gamma)
}
\arguments{
\item{R}{residual}

\item{nobs}{number of observations}

\item{lambda}{a user supplied lambda sequence. Typically, by leaving this
option unspecified users can have the program compute its own lambda
sequence based on \code{nlambda} and \code{lambda.factor}. Supplying a
value of lambda overrides this. It is better to supply a decreasing
sequence of lambda values than a single (small) value, if not, the program
will sort user-defined lambda sequence in decreasing order automatically.
Default: \code{NULL}.}

\item{alpha}{the mixing tuning parameter, with \eqn{0<\alpha<1}. It controls
the penalization strength between the main effects and the interactions.
The penalty is defined as \deqn{\lambda(1-\alpha)(w_e|\beta_e|+ \sum w_j
||\beta_j||_2) + \lambda\alpha(\sum w_{je} |\gamma_j|)}Larger values of
\code{alpha} will favor selection of main effects over interactions.
Smaller values of \code{alpha} will allow more interactions to enter the
final model. Default: \code{0.5}}

\item{we}{penalty factor for exposure variable}

\item{wj}{penalty factor for main effects}

\item{wje}{penalty factor for interactions}

\item{betaE}{estimate of exposure effect}

\item{theta_list}{estimates of main effects}

\item{gamma}{estimates of gamma parameter}
}
\value{
value of the objective function
}
\description{
calculates likelihood function. Used to assess convergence of
  fitting algorithm. This corresponds to the Q(theta) function in the paper
}
