% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename-metadata.R
\name{sf_rename_metadata}
\alias{sf_rename_metadata}
\title{Rename Metadata Elements in Salesforce}
\usage{
sf_rename_metadata(metadata_type, old_fullname, new_fullname,
  verbose = FALSE)
}
\arguments{
\item{metadata_type}{character; string on what type of metadata to create}

\item{old_fullname}{character; string corresponding to the fullName of the element you would 
like to rename}

\item{new_fullname}{character; string corresponding to the new fullName you would like 
to apply the targeted element}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{data.frame} containing the creation result for each submitted metadata component
}
\description{
This function takes an old and new name for a 
metadata element in Salesforce and applies the new name
}
\examples{
\dontrun{
renamed_custom_object <- sf_rename_metadata(metadata_type = 'CustomObject', 
                                            old_fullname = 'Custom_Account32__c', 
                                            new_fullname = 'Custom_Account99__c')
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/}
}
