% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attachments.R
\name{sf_delete_attachment}
\alias{sf_delete_attachment}
\title{Delete Attachments}
\usage{
sf_delete_attachment(
  ids,
  object_name = c("Attachment"),
  api_type = c("SOAP", "REST", "Bulk 1.0", "Bulk 2.0"),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{ids}{\code{vector}, \code{matrix}, \code{data.frame}, or
\code{tbl_df}; if not a vector, there must be a column called Id (case
insensitive) that can be passed in the request.}

\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{...}{arguments passed to \code{\link{sf_control}} or further downstream
to \code{\link{sf_bulk_operation}}}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df} with details of the deleted records
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#experimental'><img src='figures/lifecycle-experimental.svg' alt='Experimental lifecycle'></a>}}{\strong{Experimental}}

This function is a wrapper around \code{\link{sf_delete}} that accepts a list
of Ids and assumes that they are in the Attachment object and should be deleted.
This function is solely provided as a convenience and to provide the last
attachment function to parallel the CRUD functionality for all other records.
}
\note{
Because the SOAP and REST calls chunk data into batches of 200 records
the AllOrNoneHeader will only apply to the success or failure of every batch
of records and not all records submitted to the function.
}
\examples{
\dontrun{
# upload a PDF to a particular record as an Attachment
file_path <- system.file("extdata",
                         "data-wrangling-cheatsheet.pdf",
                         package = "salesforcer")
parent_record_id <- "0036A000002C6MmQAK" # replace with your own ParentId!
attachment_details <- tibble(Body = file_path, ParentId = parent_record_id)
create_result <- sf_create_attachment(attachment_details)

# now delete the attachment
# note that the function below is just running the following!
# sf_delete(ids = create_result$id)
sf_delete_attachment(ids = create_result$id)
}
}
\seealso{
Other Attachment functions: 
\code{\link{check_and_encode_files}()},
\code{\link{sf_create_attachment}()},
\code{\link{sf_download_attachment}()},
\code{\link{sf_update_attachment}()}
}
\concept{Attachment functions}
