% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_delete_job_bulk}
\alias{sf_delete_job_bulk}
\title{Delete Bulk API Job}
\usage{
sf_delete_job_bulk(job_id, api_type = c("Bulk 2.0"), verbose = FALSE)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\description{
Delete Bulk API Job
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk('insert', 'Account')
sf_abort_job_bulk(job_info$id)
sf_delete_job_bulk(job_info$id)
}
}
