% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unidiff_Plot.R
\name{plot_uni_compare}
\alias{plot_uni_compare}
\title{plot univar data}
\usage{
plot_uni_compare(
  uni_compare_objects,
  name_dfs = NULL,
  name_benchmarks = NULL,
  summetric = NULL,
  colors = NULL,
  shapes = NULL,
  legendlabels = NULL,
  legendtitle = NULL,
  label_x = NULL,
  label_y = NULL,
  summet_size = NULL,
  plot_title = NULL,
  conf_adjustment = FALSE,
  varlabels = NULL,
  ndigits = 3
)
}
\arguments{
\item{uni_compare_objects}{A object generated by the \code{\link[sampcompR]{uni_compare}}
function.}

\item{name_dfs, name_benchmarks}{A character string or vector of character
strings containing the new names of the data frames and the benchmarks, that
are used in the plot.}

\item{summetric}{If \code{"avg1"},\code{"avg2"}, \code{"mse1"},\code{"mse2"},
\code{"rmse1"},\code{"rmse2"}, or \code{"R"} the respective measure is
calculated for the biases of each survey. The values \code{"avg1"},
\code{"mse1"} and \code{"rmse1"} lead to similar results as in \code{"avg2"},
\code{"mse2"} and \code{"rmse2"}, with slightly different visualization in
the plot. If \code{summetric = "none"}, no \code{summetric} will be displayed in the
plot, and if \code{summetric = NULL} the \code{summetric} specified in the
uni_compare_object is used.}

\item{colors}{A vector of colors that is used in the plot for the
different comparisons.}

\item{shapes}{A vector of shapes applicable in \code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2()}} that is
used in the plot for the different comparisons.}

\item{legendlabels}{A character string or vector of strings containing a
label for the legend.}

\item{legendtitle}{A character string containing the title of the legend.}

\item{label_x, label_y}{A character string or vector of character strings
containing a label for the x-axis and y-axis.}

\item{summet_size}{A number to determine the size of the displayed
\code{summetric} in the plot.}

\item{plot_title}{A character string containing the title of the plot.}

\item{conf_adjustment}{If \code{conf_adjustment = TRUE} the confidence level
of the confidence interval will be
adjusted with a Bonferroni adjustment, to account for the problem of multiple
comparisons.}

\item{varlabels}{A character string or vector of character strings
containing the new names of the variables, also used in plot.}

\item{ndigits}{The number of digits to round the numbers in the plot.}
}
\value{
Plot of a \code{\link[sampcompR]{uni_compare}} object using
\code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2()}} which shows the difference between two or more data
frames.
}
\description{
\code{plot_uni_compare} This uses ggplot2 to generate a plot based on an object
generated by the \code{\link[sampcompR]{uni_compare}} function.
}
\examples{

## Get Data for comparison

data("card")

south <- card[card$south==1,]
north <- card[card$south==0,]
black <- card[card$black==1,]
white <- card[card$black==0,]

## use the function to plot the data 
univar_data<-sampcompR::uni_compare(dfs = c("north","white"),
                                    benchmarks = c("south","black"),
                                    variables= c("age","educ","fatheduc","motheduc","wage","IQ"),
                                    funct = "abs_rel_mean",
                                    nboots=0,
                                    summetric="rmse2",
                                    data=TRUE)

sampcompR::plot_uni_compare(univar_data)

}
