% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelPWR.R
\docType{class}
\name{ModelPWR-class}
\alias{ModelPWR-class}
\alias{ModelPWR}
\title{A Reference Class which represents a fitted PWR model.}
\description{
ModelPWR represents an estimated PWR model.
}
\section{Fields}{

\describe{
\item{\code{param}}{A \link{ParamPWR} object. It contains the estimated values
of the parameters.}

\item{\code{stat}}{A \link{StatPWR} object. It contains all the statistics
associated to the PWR model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("regressors", "segmentation"), ...)}}{Plot method.
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"regressors" = } Polynomial regression components
        (field \code{regressors} of class \link{StatPWR}).
      \item \code{"segmentation" = } Estimated signal
        (field \code{mean_function} of class \link{StatPWR}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}
By default, all the graphs mentioned above are produced.}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
  \item{\code{digits}}{The number of significant digits to use when
    printing.}
}}
}}

\examples{
data(univtoydataset)

pwr <- fitPWRFisher(univtoydataset$x, univtoydataset$y, K = 5, p = 1)

# pwr is a ModelPWR object. It contains some methods such as 'summary' and 'plot'
pwr$summary()
pwr$plot()

# pwr has also two fields, stat and param which are reference classes as well

# Value of the objective function:
pwr$stat$objective

# Parameters of the polynomial regressions:
pwr$param$beta
}
\seealso{
\link{ParamPWR}, \link{StatPWR}
}
